/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.osgi;

import com.openexchange.mail.transport.TransportProvider;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class TransportProviderProxyGenerator {
    public static TransportProvider newTransportProviderProxy(ServiceReference mailProviderServiceReference, BundleContext context) {
        return (TransportProvider)Proxy.newProxyInstance(TransportProvider.class.getClassLoader(), new Class[]{TransportProvider.class}, (InvocationHandler)new MailProviderInvocationHandler(mailProviderServiceReference, context));
    }

    private TransportProviderProxyGenerator() {
    }

    private static final class MailProviderInvocationHandler
    implements InvocationHandler {
        private final BundleContext context;
        private final ServiceReference transportProviderServiceReference;

        private MailProviderInvocationHandler(ServiceReference transportProviderServiceReference, BundleContext context) {
            this.transportProviderServiceReference = transportProviderServiceReference;
            this.context = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result;
            try {
                TransportProvider provider = (TransportProvider)this.context.getService(this.transportProviderServiceReference);
                try {
                    result = method.invoke((Object)provider, args);
                }
                finally {
                    this.context.ungetService(this.transportProviderServiceReference);
                }
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            catch (Exception e) {
                throw new RuntimeException("unexpected invocation exception: " + e.getMessage(), e);
            }
            return result;
        }
    }
}

