/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.cache.CacheFolderStorage;
import com.openexchange.groupware.i18n.MailStrings;
import com.openexchange.groupware.ldap.User;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.java.Strings;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailField;
import com.openexchange.mail.MailSortField;
import com.openexchange.mail.OrderDirection;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailFolderDescription;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.permission.DefaultMailPermission;
import com.openexchange.mail.search.ComparisonType;
import com.openexchange.mail.search.ReceivedDateTerm;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mailaccount.Attribute;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountDescription;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.ServiceLookup;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.threadpool.AbstractTask;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.session.ServerSession;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@Action(method=RequestMethod.PUT, name="archive_folder", description="Moves mails to archive folder from given folder using certain criteria", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="days", description="The days threshold to use."), @Parameter(name="folder", description="Object ID of the source folder.")}, responseDescription="A JSON true response.")
public final class ArchiveFolderAction
extends AbstractMailAction {
    public ArchiveFolderAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = null;
        try {
            Object af;
            String parentFullName;
            char separator;
            String archiveName;
            String sDays = req.getRequest().getParameter("days");
            int days = Strings.isEmpty((String)sDays) ? MailProperties.getInstance().getDefaultArchiveDays() : Strings.parsePositiveInt((String)sDays.trim());
            String sourceFolder = req.checkParameter("folder");
            MailAccountStorageService service = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class);
            if (null == service) {
                throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{MailAccountStorageService.class.getName()});
            }
            ServerSession session = req.getSession();
            FullnameArgument fa = MailFolderUtility.prepareMailFolderParam(sourceFolder);
            final int accountId = fa.getAccountId();
            MailAccount mailAccount = service.getMailAccount(accountId, session.getUserId(), session.getContextId());
            mailAccess = MailAccess.getInstance(session, accountId);
            mailAccess.connect();
            String archiveFullname = mailAccount.getArchiveFullname();
            if (ArchiveFolderAction.isEmpty(archiveFullname)) {
                MailAccountStorageService mass;
                String prefix;
                archiveName = mailAccount.getArchive();
                boolean updateAccount = false;
                if (ArchiveFolderAction.isEmpty(archiveName)) {
                    User user = session.getUser();
                    if (!AJAXRequestDataTools.parseBoolParameter("useDefaultName", req.getRequest(), true)) {
                        String i18nArchive = StringHelper.valueOf(user.getLocale()).getString(MailStrings.ARCHIVE);
                        throw MailExceptionCode.MISSING_DEFAULT_FOLDER_NAME.create(Category.CATEGORY_USER_INPUT, new Object[]{i18nArchive});
                    }
                    archiveName = StringHelper.valueOf(user.getLocale()).getString(MailStrings.DEFAULT_ARCHIVE);
                    updateAccount = true;
                }
                if (ArchiveFolderAction.isEmpty(prefix = mailAccess.getFolderStorage().getDefaultFolderPrefix())) {
                    separator = mailAccess.getFolderStorage().getFolder("INBOX").getSeparator();
                    archiveFullname = archiveName;
                    parentFullName = "default";
                } else {
                    separator = prefix.charAt(prefix.length() - 1);
                    archiveFullname = prefix + archiveName;
                    parentFullName = prefix.substring(0, prefix.length() - 1);
                }
                if (updateAccount && null != (mass = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class))) {
                    af = archiveFullname;
                    ThreadPools.getThreadPool().submit((Task)new AbstractTask<Void>((String)af, mass, session){
                        final /* synthetic */ String val$af;
                        final /* synthetic */ MailAccountStorageService val$mass;
                        final /* synthetic */ ServerSession val$session;
                        {
                            this.val$af = string;
                            this.val$mass = mailAccountStorageService;
                            this.val$session = serverSession;
                        }

                        public Void call() throws Exception {
                            MailAccountDescription mad = new MailAccountDescription();
                            mad.setId(accountId);
                            mad.setArchiveFullname(this.val$af);
                            this.val$mass.updateMailAccount(mad, EnumSet.of(Attribute.ARCHIVE_FULLNAME_LITERAL), this.val$session.getUserId(), this.val$session.getContextId(), this.val$session);
                            return null;
                        }
                    });
                }
            } else {
                separator = mailAccess.getFolderStorage().getFolder("INBOX").getSeparator();
                int pos = archiveFullname.lastIndexOf(separator);
                if (pos > 0) {
                    parentFullName = archiveFullname.substring(0, pos);
                    archiveName = archiveFullname.substring(pos + 1);
                } else {
                    parentFullName = "default";
                    archiveName = archiveFullname;
                }
            }
            if (!mailAccess.getFolderStorage().exists(archiveFullname)) {
                if (!AJAXRequestDataTools.parseBoolParameter("createIfAbsent", req.getRequest(), true)) {
                    throw MailExceptionCode.FOLDER_NOT_FOUND.create(archiveFullname);
                }
                MailFolderDescription toCreate = new MailFolderDescription();
                toCreate.setAccountId(accountId);
                toCreate.setParentAccountId(accountId);
                toCreate.setParentFullname(parentFullName);
                toCreate.setExists(false);
                toCreate.setFullname(archiveFullname);
                toCreate.setName(archiveName);
                toCreate.setSeparator(separator);
                DefaultMailPermission mp = new DefaultMailPermission();
                mp.setEntity(session.getUserId());
                int p = 128;
                mp.setAllPermission(128, 128, 128, 128);
                mp.setFolderAdmin(true);
                mp.setGroupPermission(false);
                toCreate.addPermission(mp);
                mailAccess.getFolderStorage().createFolder(toCreate);
                CacheFolderStorage.getInstance().removeFromCache(parentFullName, "0", true, session);
            }
            Calendar cal = Calendar.getInstance(TimeZoneUtils.getTimeZone("UTC"));
            cal.set(14, 0);
            cal.set(13, 0);
            cal.set(12, 0);
            cal.set(11, 0);
            cal.add(5, days * -1);
            ReceivedDateTerm term = new ReceivedDateTerm(ComparisonType.LESS_THAN, cal.getTime());
            MailMessage[] msgs = mailAccess.getMessageStorage().searchMessages(fa.getFullname(), null, MailSortField.RECEIVED_DATE, OrderDirection.DESC, term, new MailField[]{MailField.ID, MailField.RECEIVED_DATE});
            if (null == msgs || msgs.length <= 0) {
                af = new AJAXRequestResult((Object)Boolean.TRUE, "native");
                return af;
            }
            HashMap<Integer, LinkedList<String>> map = new HashMap<Integer, LinkedList<String>>(4);
            for (MailMessage mailMessage : msgs) {
                Date receivedDate = mailMessage.getReceivedDate();
                cal.setTime(receivedDate);
                Integer year = cal.get(1);
                LinkedList<String> ids = (LinkedList<String>)map.get(year);
                if (null == ids) {
                    ids = new LinkedList<String>();
                    map.put(year, ids);
                }
                ids.add(mailMessage.getMailId());
            }
            for (Map.Entry entry : map.entrySet()) {
                String sYear = ((Integer)entry.getKey()).toString();
                String fn = archiveFullname + separator + sYear;
                if (!mailAccess.getFolderStorage().exists(fn)) {
                    MailFolderDescription toCreate = new MailFolderDescription();
                    toCreate.setAccountId(accountId);
                    toCreate.setParentAccountId(accountId);
                    toCreate.setParentFullname(archiveFullname);
                    toCreate.setExists(false);
                    toCreate.setFullname(fn);
                    toCreate.setName(sYear);
                    toCreate.setSeparator(separator);
                    DefaultMailPermission mp = new DefaultMailPermission();
                    mp.setEntity(session.getUserId());
                    int p = 128;
                    mp.setAllPermission(128, 128, 128, 128);
                    mp.setFolderAdmin(true);
                    mp.setGroupPermission(false);
                    toCreate.addPermission(mp);
                    mailAccess.getFolderStorage().createFolder(toCreate);
                    CacheFolderStorage.getInstance().removeFromCache(archiveFullname, "0", true, session);
                }
                List ids = (List)entry.getValue();
                mailAccess.getMessageStorage().moveMessages(fa.getFullname(), fn, ids.toArray(new String[ids.size()]), true);
            }
            AJAXRequestResult aJAXRequestResult = new AJAXRequestResult((Object)Boolean.TRUE, "native");
            return aJAXRequestResult;
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (null != mailAccess) {
                mailAccess.close(true);
            }
        }
    }
}

