/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n.tools.replacement;

import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.i18n.tools.TemplateToken;
import com.openexchange.i18n.tools.replacement.AbstractFormatMultipleDateReplacement;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class ChangeExceptionsReplacement
extends AbstractFormatMultipleDateReplacement {
    private boolean changeException;
    private String recurrenceTitle;

    public ChangeExceptionsReplacement(Date[] dates) {
        this(dates, null, null);
    }

    public ChangeExceptionsReplacement(Date[] dates, Locale locale, TimeZone timeZone) {
        super(dates, "Change exceptions: %1$s", locale, timeZone);
        this.fallback = "No change exceptions";
    }

    @Override
    public String getReplacement() {
        String result;
        if (this.dates == null || this.dates.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(this.dates.length << 4);
        builder.append(this.dateFormat.format(this.dates[0]));
        for (int i = 1; i < this.dates.length; ++i) {
            builder.append(", ").append(this.dateFormat.format(this.dates[i]));
        }
        String datesRepl = builder.toString();
        if (this.changeException) {
            this.format = "Change exception of %1$s on %2$s";
            result = String.format(StringHelper.valueOf(this.locale == null ? Locale.ENGLISH : this.locale).getString(this.format), this.recurrenceTitle, datesRepl);
            return new StringBuilder(1 + result.length()).append(result).append('\n').toString();
        }
        result = String.format(StringHelper.valueOf(this.locale == null ? Locale.ENGLISH : this.locale).getString(this.format), datesRepl);
        if (this.changed) {
            return new StringBuilder("* ".length() + result.length() + 1).append("* ").append(result).append('\n').toString();
        }
        return new StringBuilder(1 + result.length()).append(result).append('\n').toString();
    }

    @Override
    public TemplateToken getToken() {
        return TemplateToken.CHANGE_EXCEPTIONS;
    }

    public boolean isChangeException() {
        return this.changeException;
    }

    public void setChangeException(boolean changeException) {
        this.changeException = changeException;
    }

    public String getRecurrenceTitle() {
        return this.recurrenceTitle;
    }

    public void setRecurrenceTitle(String recurrenceTitle) {
        this.recurrenceTitle = recurrenceTitle;
    }
}

