/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.reminder.ReminderExceptionCode;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoveBrokenReminder
implements UpdateTask {
    private static final Logger LOG = LoggerFactory.getLogger(RemoveBrokenReminder.class);

    @Override
    public int addedWithVersion() {
        return 20;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        LOG.info("Performing update task TaskModifiedByNotNull.");
        Connection con = null;
        try {
            con = Database.get(contextId, true);
        }
        catch (OXException e) {
            throw TaskExceptionCode.NO_CONNECTION.create(e, new Object[0]);
        }
        try {
            con.setAutoCommit(false);
            ReminderObject[] broken = this.getBroken(con);
            this.deleteBroken(con, broken);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw ReminderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.rollback(con);
            throw e;
        }
        finally {
            DBUtils.autocommit(con);
            Database.back(contextId, true, con);
        }
    }

    private void deleteBroken(Connection con, ReminderObject[] brokens) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("DELETE FROM reminder WHERE cid=? AND object_id=?");
            for (ReminderObject broken : brokens) {
                stmt.setInt(1, broken.getTargetId());
                stmt.setInt(2, broken.getObjectId());
                stmt.addBatch();
            }
            int[] mRows = stmt.executeBatch();
            int rows = 0;
            for (int mRow : mRows) {
                rows += mRow;
            }
            if (brokens.length != rows) {
                throw ReminderExceptionCode.SQL_ERROR.create("Strangely deleted " + rows + " instead of " + brokens.length);
            }
        }
        catch (SQLException e) {
            throw ReminderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
    }

    private ReminderObject[] getBroken(Connection con) throws OXException {
        ArrayList tmp = new ArrayList();
        Statement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.createStatement();
            result = stmt.executeQuery("SELECT r.cid,r.object_id FROM reminder r JOIN oxfolder_tree f ON r.cid=f.cid AND r.folder=f.fuid WHERE (r.module=4 AND f.module!=1) OR (r.module=1 AND f.module!=2)");
            while (result.next()) {
                ReminderObject broken = new ReminderObject();
                broken.setTargetId(result.getInt(1));
                broken.setObjectId(result.getInt(2));
            }
        }
        catch (SQLException e) {
            try {
                throw ReminderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return tmp.toArray(new ReminderObject[tmp.size()]);
    }
}

