/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

public enum TaskField {
    OBJECTID(1, "ObjectID"),
    CREATEDBY(2, "CreatedBy"),
    CREATIONDATE(4, "CreationDate"),
    MODIFIEDBY(3, "ModifiedBy"),
    LASTMODIFIED(5, "LastModified"),
    PARENTFOLDERID(20, "ParentFolderID"),
    TITLE(200, "Title"),
    STARTDATE(201, "StartDate"),
    ENDDATE(202, "EndDate"),
    NOTE(203, "Note"),
    ACTUALCOSTS(302, "ActualCosts"),
    ACTUALDURATION(303, "ActualDuration"),
    BILLINGINFORMATION(305, "BillingInformation"),
    CATEGORIES(100, "Categories"),
    COMPANIES(314, "Companies"),
    CURRENCY(312, "Currency"),
    DATECOMPLETED(315, "DateCompleted"),
    PERCENTCOMPLETE(301, "PercentComplete"),
    PRIORITY(309, "Priority"),
    STATUS(300, "Status"),
    TARGETCOSTS(307, "TargetCosts"),
    TARGETDURATION(308, "TargetDuration"),
    TRIPMETER(313, "TripMeter"),
    RECURRENCETYPE(209, "RecurrenceType"),
    LABEL(102, "Label"),
    UID(223, "UID");

    private int taskID;
    private String name;

    private TaskField(int taskID, String name) {
        this.taskID = taskID;
        this.name = name;
    }

    public static TaskField getByTaskID(int id) {
        for (TaskField field : TaskField.values()) {
            if (field.getTaskID() != id) continue;
            return field;
        }
        return null;
    }

    public static TaskField getByName(String name) {
        for (TaskField field : TaskField.values()) {
            if (!name.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getTaskID() {
        return this.taskID;
    }

    public void setTaskID(int taskID) {
        this.taskID = taskID;
    }

    public String getICalName() {
        return this.name;
    }
}

