/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings.tree.modules.mail;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.PreferencesItemService;
import com.openexchange.groupware.settings.ReadOnlyValue;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mailaccount.UnifiedInboxManagement;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnifiedInboxIdentifier
implements PreferencesItemService {
    static final Logger LOG = LoggerFactory.getLogger(UnifiedInboxIdentifier.class);

    @Override
    public String[] getPath() {
        return new String[]{"modules", "mail", "unifiedinboxidentifier"};
    }

    @Override
    public IValueHandler getSharedValue() {
        return new ReadOnlyValue(){

            @Override
            public void getValue(Session session, Context ctx, User user, UserConfiguration userConfig, Setting setting) throws OXException {
                try {
                    UnifiedInboxManagement management = ServerServiceRegistry.getInstance().getService(UnifiedInboxManagement.class, true);
                    int id = management.getUnifiedINBOXAccountIDIfEnabled(session.getUserId(), session.getContextId());
                    if (id >= 0) {
                        setting.setSingleValue(MailFolderUtility.prepareFullname(id, "INBOX"));
                    } else {
                        setting.setSingleValue("null");
                    }
                }
                catch (OXException e) {
                    LOG.warn("", (Throwable)e);
                    setting.setSingleValue("null");
                    return;
                }
            }

            @Override
            public boolean isAvailable(UserConfiguration userConfig) {
                return userConfig.hasWebMail();
            }
        };
    }
}

