/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.database.impl;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.database.tx.AbstractDBAction;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.database.impl.AbstractDocumentListAction;
import com.openexchange.groupware.infostore.database.impl.InfostoreQueryCatalog;
import com.openexchange.java.Autoboxing;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class CreateDocumentAction
extends AbstractDocumentListAction {
    public CreateDocumentAction() {
    }

    public CreateDocumentAction(DBProvider provider, InfostoreQueryCatalog queryCatalog, Context context, List<DocumentMetadata> documents) {
        super(provider, queryCatalog, context, documents);
    }

    protected void undoAction() throws OXException {
        List<String> deleteStmts = this.getQueryCatalog().getDelete(InfostoreQueryCatalog.Table.INFOSTORE, this.getDocuments());
        ArrayList<AbstractDBAction.UpdateBlock> updates = new ArrayList<AbstractDBAction.UpdateBlock>(2);
        for (String deleteStmt : deleteStmts) {
            AbstractDBAction.Update update = new AbstractDBAction.Update(deleteStmt){

                @Override
                public void fillStatement() throws SQLException {
                    this.stmt.setInt(1, CreateDocumentAction.this.getContext().getContextId());
                }
            };
            updates.add(update);
        }
        this.doUpdates(updates);
    }

    public void perform() throws OXException {
        this.doUpdates(this.getQueryCatalog().getDocumentInsert(), this.getQueryCatalog().getWritableDocumentFields(), this.getDocuments());
    }

    @Override
    protected Object[] getAdditionals(DocumentMetadata doc) {
        return new Object[]{Autoboxing.I((int)this.getContext().getContextId())};
    }
}

