/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.group;

import java.util.Date;

public class Group
implements Cloneable {
    public static int[] ALL_COLUMNS = new int[]{Field.FULL_NAME.getColNumber(), Field.ID.getColNumber(), Field.LAST_MODIFIED.getColNumber(), Field.SIMPLE_NAME.getColNumber(), Field.MEMBERS.getColNumber()};
    public static int[] ALL_COLUMNS_EXCEPT_MEMBERS = new int[]{Field.FULL_NAME.getColNumber(), Field.ID.getColNumber(), Field.LAST_MODIFIED.getColNumber(), Field.SIMPLE_NAME.getColNumber()};
    private int identifier = -1;
    private boolean identifierSet;
    private String simpleName;
    private boolean simpleNameSet;
    private int[] member = new int[0];
    private boolean memberSet;
    private String displayName;
    private boolean displayNameSet;
    private Date lastModified;
    private boolean lastModifiedSet;

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        this.displayNameSet = true;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setIdentifier(int identifier) {
        this.identifier = identifier;
        this.identifierSet = true;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public void setMember(int[] member) {
        this.member = member;
        this.memberSet = true;
    }

    public int[] getMember() {
        return this.member;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
        this.lastModifiedSet = true;
    }

    public Object clone() throws CloneNotSupportedException {
        Group retval = (Group)super.clone();
        if (null != this.lastModified) {
            retval.lastModified = (Date)this.lastModified.clone();
        }
        if (null != this.member) {
            retval.member = new int[this.member.length];
            System.arraycopy(this.member, 0, retval.member, 0, this.member.length);
        }
        return retval;
    }

    public final String getSimpleName() {
        return this.simpleName;
    }

    public final void setSimpleName(String simpleName) {
        this.simpleName = simpleName;
        this.simpleNameSet = true;
    }

    public final boolean isIdentifierSet() {
        return this.identifierSet;
    }

    public final boolean isSimpleNameSet() {
        return this.simpleNameSet;
    }

    public final boolean isMemberSet() {
        return this.memberSet;
    }

    public final boolean isDisplayNameSet() {
        return this.displayNameSet;
    }

    public final boolean isLastModifiedSet() {
        return this.lastModifiedSet;
    }

    public Object get(Field field) {
        if (field == Field.FULL_NAME) {
            return this.getDisplayName();
        }
        if (field == Field.SIMPLE_NAME) {
            return this.getSimpleName();
        }
        if (field == Field.ID) {
            return this.getIdentifier();
        }
        if (field == Field.LAST_MODIFIED) {
            return this.getLastModified();
        }
        if (field == Field.MEMBERS) {
            return this.getMember();
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("(Group ID:");
        sb.append(this.getIdentifier());
        sb.append(" name:");
        sb.append(this.getSimpleName());
        sb.append(" displayName:");
        sb.append(this.getDisplayName());
        sb.append(" member:");
        for (int member : this.getMember()) {
            sb.append(member);
            sb.append(',');
        }
        sb.setCharAt(sb.length() - 1, ')');
        return sb.toString();
    }

    public static enum Field {
        ID(1, "id", "id"),
        LAST_MODIFIED(5, "last_modified", "lastModified"),
        SIMPLE_NAME(700, "name", "identifier"),
        FULL_NAME(701, "display_name", "displayName"),
        MEMBERS(702, "members", null);

        private int colNumber;
        private String ajaxName;
        private String dbName;

        private Field(int colNumber, String ajaxName, String dbName) {
            this.setColNumber(colNumber);
            this.setAjaxName(ajaxName);
            this.setDbName(dbName);
        }

        public void setColNumber(int colNumber) {
            this.colNumber = colNumber;
        }

        public int getColNumber() {
            return this.colNumber;
        }

        public void setAjaxName(String ajaxName) {
            this.ajaxName = ajaxName;
        }

        public String getAjaxName() {
            return this.ajaxName;
        }

        public void setDbName(String dbName) {
            this.dbName = dbName;
        }

        public String getDbName() {
            return this.dbName;
        }

        public static Field getByColumnNumber(int num) {
            for (Field val : Field.values()) {
                if (val.getColNumber() != num) continue;
                return val;
            }
            return null;
        }

        public static int[] intValues() {
            Field[] vals = Field.values();
            int[] retVal = new int[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                retVal[i] = vals[i].getColNumber();
            }
            return retVal;
        }
    }
}

