/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.database.contentType.InfostoreContentType;
import com.openexchange.folderstorage.internal.Tools;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.InfostoreFacades;
import com.openexchange.groupware.userconfiguration.AllowAllUserPermissionBits;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.groupware.userconfiguration.UserPermissionBitsStorage;
import com.openexchange.tools.oxfolder.OXFolderProperties;
import gnu.trove.EmptyTIntSet;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class EffectivePermission
implements Permission {
    private static final long serialVersionUID = -6459987256871091818L;
    private static final int MODULE_INFOSTORE = InfostoreContentType.getInstance().getModule();
    private static final String GAB = Integer.toString(6);
    private static final String INFOSTORE = Integer.toString(9);
    private static final String INFOSTORE_USER = Integer.toString(10);
    private static final String INFOSTORE_PUBLIC = Integer.toString(15);
    private static final Set<String> SYSTEM_INFOSTORES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(INFOSTORE, INFOSTORE_PUBLIC, INFOSTORE_USER)));
    private UserPermissionBits userPermissionBits;
    private TIntSet allowedContentTypes;
    private final Type type;
    private final ContentType contentType;
    private final String folderId;
    private Permission underlyingPerm;
    private int entityId;
    private Context context;

    public EffectivePermission(Permission underlyingPerm, String folderId, Type type, ContentType contentType, UserPermissionBits userPermissionBits, List<ContentType> allowedContentTypes) {
        this.underlyingPerm = underlyingPerm;
        this.folderId = folderId;
        this.contentType = contentType;
        this.type = type;
        this.userPermissionBits = userPermissionBits;
        if (null == allowedContentTypes || allowedContentTypes.isEmpty()) {
            this.allowedContentTypes = EmptyTIntSet.getInstance();
        } else {
            TIntHashSet set = new TIntHashSet(allowedContentTypes.size() + 1);
            for (ContentType allowedContentType : allowedContentTypes) {
                set.add(allowedContentType.getModule());
            }
            set.add(5);
            set.add(4);
            this.allowedContentTypes = set;
        }
        this.entityId = -1;
    }

    public EffectivePermission setEntityInfo(int entityId, Context context) {
        this.setEntity(entityId);
        this.context = context;
        return this;
    }

    @Override
    public boolean isVisible() {
        return this.isAdmin() || this.getFolderPermission() > 0;
    }

    public int hashCode() {
        return this.underlyingPerm.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Permission)) {
            return false;
        }
        Permission other = (Permission)obj;
        if (this.isAdmin() != other.isAdmin()) {
            return false;
        }
        if (this.getDeletePermission() != other.getDeletePermission()) {
            return false;
        }
        if (this.getEntity() != other.getEntity()) {
            return false;
        }
        if (this.getFolderPermission() != other.getFolderPermission()) {
            return false;
        }
        if (this.isGroup() != other.isGroup()) {
            return false;
        }
        if (this.getReadPermission() != other.getReadPermission()) {
            return false;
        }
        if (this.getSystem() != other.getSystem()) {
            return false;
        }
        return this.getWritePermission() == other.getWritePermission();
    }

    private boolean hasModuleAccess() {
        int module = this.getModule();
        if (!this.getUserPermissionBits().hasModuleAccess(module)) {
            return false;
        }
        if (MODULE_INFOSTORE == module && !InfostoreFacades.isInfoStoreAvailable() && !SYSTEM_INFOSTORES.contains(this.folderId) && this.isNumericId()) {
            return false;
        }
        return this.allowedContentTypes.isEmpty() || this.allowedContentTypes.contains(module);
    }

    private boolean isNumericId() {
        return Tools.getUnsignedInteger(this.folderId) >= 0;
    }

    private UserPermissionBits getUserPermissionBits() {
        UserPermissionBits userPermissionBits = this.userPermissionBits;
        if (null == userPermissionBits) {
            try {
                userPermissionBits = this.userPermissionBits = UserPermissionBitsStorage.getInstance().getUserPermissionBits(this.getEntity(), this.context);
            }
            catch (OXException e) {
                userPermissionBits = this.userPermissionBits = new AllowAllUserPermissionBits(this.getEntity(), null, this.context.getContextId());
            }
        }
        return userPermissionBits;
    }

    private int getType() {
        return null != this.type ? this.type.getType() : -1;
    }

    private int getModule() {
        return this.contentType.getModule();
    }

    @Override
    public int getDeletePermission() {
        if (!this.hasModuleAccess()) {
            return 0;
        }
        if (2 == this.getType() || String.valueOf(2).equals(this.folderId) ? this.getModule() != 8 && !this.getUserPermissionBits().hasFullPublicFolderAccess() : !this.getUserPermissionBits().hasFullSharedFolderAccess() && 3 == this.getType()) {
            return 0;
        }
        return this.underlyingPerm.getDeletePermission();
    }

    @Override
    public int getEntity() {
        return this.entityId <= 0 ? this.underlyingPerm.getEntity() : this.entityId;
    }

    @Override
    public int getFolderPermission() {
        if (!this.hasModuleAccess()) {
            return 0;
        }
        if (2 == this.getType() || String.valueOf(2).equals(this.folderId)) {
            if (this.getModule() != 8 && !this.getUserPermissionBits().hasFullPublicFolderAccess()) {
                int folderPermission = this.underlyingPerm.getFolderPermission();
                return folderPermission > 2 ? 2 : folderPermission;
            }
        } else if (!this.getUserPermissionBits().hasFullSharedFolderAccess() && 3 == this.getType()) {
            return 0;
        }
        return this.underlyingPerm.getFolderPermission();
    }

    @Override
    public int getReadPermission() {
        if (!this.hasModuleAccess()) {
            return 0;
        }
        if (2 == this.getType() || String.valueOf(2).equals(this.folderId)) {
            if (this.getModule() != 8 && !this.getUserPermissionBits().hasFullPublicFolderAccess()) {
                int readPermission = this.underlyingPerm.getReadPermission();
                return readPermission > 4 ? 4 : readPermission;
            }
        } else if (!this.getUserPermissionBits().hasFullSharedFolderAccess() && 3 == this.getType()) {
            return 0;
        }
        return this.underlyingPerm.getReadPermission();
    }

    @Override
    public int getSystem() {
        return this.underlyingPerm.getSystem();
    }

    @Override
    public int getWritePermission() {
        if (GAB.equals(this.folderId)) {
            int writePermission = this.underlyingPerm.getWritePermission();
            return OXFolderProperties.isEnableInternalUsersEdit() ? (writePermission <= 0 ? 2 : writePermission) : 0;
        }
        if (!this.hasModuleAccess()) {
            return 0;
        }
        if (2 == this.getType() || String.valueOf(2).equals(this.folderId) ? this.getModule() != 8 && !this.getUserPermissionBits().hasFullPublicFolderAccess() : !this.getUserPermissionBits().hasFullSharedFolderAccess() && 3 == this.getType()) {
            return 0;
        }
        return this.underlyingPerm.getWritePermission();
    }

    @Override
    public boolean isAdmin() {
        if (!this.hasModuleAccess()) {
            return false;
        }
        if (2 == this.getType() && this.getModule() != 8 && !this.getUserPermissionBits().hasFullPublicFolderAccess()) {
            return false;
        }
        return this.underlyingPerm.isAdmin();
    }

    @Override
    public boolean isGroup() {
        return this.underlyingPerm.isGroup();
    }

    @Override
    public void setAdmin(boolean admin) {
        throw new UnsupportedOperationException("EffectivePermission.setAdmin()");
    }

    @Override
    public void setAllPermissions(int folderPermission, int readPermission, int writePermission, int deletePermission) {
        throw new UnsupportedOperationException("EffectivePermission.setAllPermissions()");
    }

    @Override
    public void setDeletePermission(int permission) {
        throw new UnsupportedOperationException("EffectivePermission.setDeletePermission()");
    }

    @Override
    public void setEntity(int entity) {
        this.entityId = entity;
    }

    @Override
    public void setFolderPermission(int permission) {
        throw new UnsupportedOperationException("EffectivePermission.setFolderPermission()");
    }

    @Override
    public void setGroup(boolean group) {
        throw new UnsupportedOperationException("EffectivePermission.setGroup()");
    }

    @Override
    public void setMaxPermissions() {
        throw new UnsupportedOperationException("EffectivePermission.setMaxPermissions()");
    }

    @Override
    public void setNoPermissions() {
        throw new UnsupportedOperationException("EffectivePermission.setNoPermissions()");
    }

    @Override
    public void setReadPermission(int permission) {
        throw new UnsupportedOperationException("EffectivePermission.setReadPermission()");
    }

    @Override
    public void setSystem(int system) {
        throw new UnsupportedOperationException("EffectivePermission.setSystem()");
    }

    @Override
    public void setWritePermission(int permission) {
        throw new UnsupportedOperationException("EffectivePermission.setWritePermission()");
    }

    @Override
    public Object clone() {
        try {
            EffectivePermission clone = (EffectivePermission)super.clone();
            clone.userPermissionBits = this.getUserPermissionBits().clone();
            clone.underlyingPerm = (Permission)this.underlyingPerm.clone();
            clone.allowedContentTypes = null == this.allowedContentTypes || this.allowedContentTypes.isEmpty() ? new TIntHashSet(1) : new TIntHashSet(this.allowedContentTypes.toArray());
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }
}

