/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.cache.osgi;

import com.openexchange.caching.CacheService;
import com.openexchange.caching.events.CacheEventService;
import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.cache.CacheFolderStorage;
import com.openexchange.folderstorage.cache.CacheServiceRegistry;
import com.openexchange.folderstorage.cache.lock.UserLockManagement;
import com.openexchange.folderstorage.cache.memory.FolderMapManagement;
import com.openexchange.folderstorage.cache.osgi.CacheFolderStorageInvalidator;
import com.openexchange.folderstorage.cache.osgi.CacheFolderStorageServiceTracker;
import com.openexchange.folderstorage.cache.osgi.FolderMapInvalidator;
import com.openexchange.folderstorage.cache.service.FolderCacheInvalidationService;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.osgi.DeferredActivator;
import com.openexchange.osgi.ServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessiondEventConstants;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.threadpool.AbstractTask;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.behavior.CallerRunsBehavior;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CacheFolderStorageActivator
extends DeferredActivator {
    static final Logger LOG = LoggerFactory.getLogger(CacheFolderStorageActivator.class);
    private volatile CacheFolderStorage cacheFolderStorage;
    private volatile List<ServiceRegistration<?>> registrations;
    private volatile List<ServiceTracker<?, ?>> serviceTrackers;
    private static final String DEFAULT = "default";
    private static final Pattern PAT_FIX = Pattern.compile(Pattern.quote("default") + "([0-9]+)" + Pattern.quote("default"));

    protected Class<?>[] getNeededServices() {
        return new Class[]{CacheService.class, ThreadPoolService.class, ConfigurationService.class, SessiondService.class, MailAccountStorageService.class, CacheEventService.class};
    }

    protected void handleAvailability(Class<?> clazz) {
        LOG.info("Re-available service: {}", (Object)clazz.getName());
        CacheServiceRegistry.getServiceRegistry().addService(clazz, this.getService(clazz));
        if (CacheService.class.equals(clazz)) {
            try {
                this.initCacheFolderStorage();
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
                this.unregisterCacheFolderStorage();
            }
        }
    }

    protected void handleUnavailability(Class<?> clazz) {
        LOG.warn("Absent service: {}", (Object)clazz.getName());
        if (CacheService.class.equals(clazz)) {
            try {
                this.disposeCacheFolderStorage();
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
                this.unregisterCacheFolderStorage();
            }
        }
        CacheServiceRegistry.getServiceRegistry().removeService(clazz);
    }

    protected void startBundle() throws Exception {
        try {
            Class<?>[] classes;
            ServiceRegistry registry = CacheServiceRegistry.getServiceRegistry();
            registry.clearRegistry();
            for (Class<?> classe : classes = this.getNeededServices()) {
                Object service = this.getService(classe);
                if (null == service) continue;
                registry.addService(classe, service);
            }
            this.initCacheFolderStorage();
            ArrayList serviceTrackers = new ArrayList(4);
            this.serviceTrackers = serviceTrackers;
            serviceTrackers.add(new ServiceTracker(this.context, FolderStorage.class, (ServiceTrackerCustomizer)new CacheFolderStorageServiceTracker(this.context)));
            serviceTrackers.add(new ServiceTracker(this.context, CacheEventService.class, (ServiceTrackerCustomizer)new CacheFolderStorageInvalidator(this.context)));
            serviceTrackers.add(new ServiceTracker(this.context, CacheEventService.class, (ServiceTrackerCustomizer)new FolderMapInvalidator(this.context)));
            for (ServiceTracker serviceTracker : serviceTrackers) {
                serviceTracker.open();
            }
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
    }

    protected void stopBundle() throws Exception {
        try {
            List<ServiceTracker<?, ?>> serviceTrackers = this.serviceTrackers;
            if (null != serviceTrackers) {
                for (ServiceTracker<?, ?> serviceTracker : serviceTrackers) {
                    serviceTracker.close();
                }
                serviceTrackers.clear();
                this.serviceTrackers = null;
            }
            this.disposeCacheFolderStorage();
            CacheServiceRegistry.getServiceRegistry().clearRegistry();
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
    }

    private void disposeCacheFolderStorage() throws OXException {
        this.unregisterCacheFolderStorage();
        CacheFolderStorage cacheFolderStorage = this.cacheFolderStorage;
        if (null != cacheFolderStorage) {
            cacheFolderStorage.onCacheAbsent();
            this.cacheFolderStorage = null;
        }
    }

    private void initCacheFolderStorage() throws OXException {
        CacheFolderStorage cache;
        this.cacheFolderStorage = cache = CacheFolderStorage.getInstance();
        cache.onCacheAvailable();
        ArrayList registrations = new ArrayList(4);
        this.registrations = registrations;
        Hashtable<String, String> dictionary = new Hashtable<String, String>(1);
        ((Dictionary)dictionary).put("tree", FolderStorage.ALL_TREE_ID);
        registrations.add(this.context.registerService(FolderStorage.class, (Object)cache, dictionary));
        registrations.add(this.context.registerService(FolderCacheInvalidationService.class, (Object)cache, null));
        Object eventHandler = new EventHandler(){

            public void handleEvent(final Event event) {
                ThreadPoolService threadPool = (ThreadPoolService)CacheFolderStorageActivator.this.getService(ThreadPoolService.class);
                if (null == threadPool) {
                    this.doHandleEvent(event);
                } else {
                    AbstractTask<Void> t = new AbstractTask<Void>(){

                        public Void call() throws Exception {
                            try {
                                this.doHandleEvent(event);
                            }
                            catch (Exception e) {
                                LOG.warn("Handling event {} failed.", (Object)event.getTopic(), (Object)e);
                            }
                            return null;
                        }
                    };
                    threadPool.submit((Task)t, CallerRunsBehavior.getInstance());
                }
            }

            protected void doHandleEvent(Event event) {
                Integer contextId;
                String topic = event.getTopic();
                if ("com/openexchange/sessiond/remove/last".equals(topic)) {
                    Integer userId;
                    Integer contextId2 = (Integer)event.getProperty("com.openexchange.sessiond.contextId");
                    if (null != contextId2 && null != (userId = (Integer)event.getProperty("com.openexchange.sessiond.userId"))) {
                        FolderMapManagement.getInstance().dropFor((int)userId, contextId2);
                        UserLockManagement.getInstance().dropFor(userId, contextId2);
                    }
                } else if ("com/openexchange/sessiond/remove/lastcontext".equals(topic) && null != (contextId = (Integer)event.getProperty("com.openexchange.sessiond.contextId"))) {
                    FolderMapManagement.getInstance().dropFor(contextId);
                    UserLockManagement.getInstance().dropFor(contextId);
                }
            }
        };
        Hashtable<String, Object> dict = new Hashtable<String, Object>(1);
        ((Dictionary)dict).put("event.topics", SessiondEventConstants.getAllTopics());
        registrations.add(this.context.registerService(EventHandler.class, eventHandler, dict));
        eventHandler = new EventHandler(){

            public void handleEvent(final Event event) {
                ThreadPoolService threadPool = (ThreadPoolService)CacheFolderStorageActivator.this.getService(ThreadPoolService.class);
                if (null == threadPool) {
                    this.doHandleEvent(cache, event);
                } else {
                    AbstractTask<Void> t = new AbstractTask<Void>(){

                        public Void call() throws Exception {
                            try {
                                this.doHandleEvent(cache, event);
                            }
                            catch (Exception e) {
                                LOG.warn("Handling event {} failed.", (Object)event.getTopic(), (Object)e);
                            }
                            return null;
                        }
                    };
                    threadPool.submit((Task)t, CallerRunsBehavior.getInstance());
                }
            }

            protected void doHandleEvent(CacheFolderStorage tmp, Event event) {
                try {
                    String folderID = (String)event.getProperty("folderId");
                    Session session = (Session)event.getProperty("session");
                    String[] folderPath = (String[])event.getProperty("folderPath");
                    tmp.removeFromGlobalCache(folderID, FolderStorage.REAL_TREE_ID, session.getContextId());
                    if (null != folderPath) {
                        tmp.removeFromCache(folderID, FolderStorage.REAL_TREE_ID, false, session, Arrays.asList(folderPath));
                    } else {
                        tmp.removeFromCache(folderID, FolderStorage.REAL_TREE_ID, false, session);
                    }
                }
                catch (OXException e) {
                    LOG.error("", (Throwable)e);
                }
            }
        };
        dict = new Hashtable(1);
        ((Dictionary)dict).put("event.topics", "com/openexchange/groupware/fsfolder/*");
        registrations.add(this.context.registerService(EventHandler.class, eventHandler, dict));
    }

    protected static String sanitizeFolderId(String id) {
        String fid = id;
        if (fid.startsWith(DEFAULT)) {
            try {
                Matcher matcher = PAT_FIX.matcher(fid);
                if (matcher.matches()) {
                    fid = DEFAULT + matcher.group(1);
                }
            }
            catch (Exception e) {
                LOG.warn("Couldn't sanitize folder identifier: {}. Returning unchanged.", (Object)id, (Object)e);
                return id;
            }
        }
        return fid;
    }

    private void unregisterCacheFolderStorage() {
        List<ServiceRegistration<?>> registrations = this.registrations;
        if (null != registrations) {
            while (!registrations.isEmpty()) {
                registrations.remove(0).unregister();
            }
            this.registrations = null;
        }
    }
}

