/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage;

import com.openexchange.folderstorage.ContentType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public final class FolderServiceDecorator {
    private TimeZone timeZone;
    private Locale locale;
    private List<ContentType> allowedContentTypes = Collections.emptyList();
    private final Map<String, Object> properties = new ConcurrentHashMap<String, Object>(8);
    private static final Set<String> BOOL_VALS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("true", "1", "yes", "y", "on")));

    public List<ContentType> getAllowedContentTypes() {
        return this.allowedContentTypes;
    }

    public FolderServiceDecorator setAllowedContentTypes(List<ContentType> allowedContentTypes) {
        this.allowedContentTypes = null == allowedContentTypes || allowedContentTypes.isEmpty() ? Collections.emptyList() : new ArrayList<ContentType>(allowedContentTypes);
        return this;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public FolderServiceDecorator setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public FolderServiceDecorator setLocale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public boolean containsProperty(String propertyName) {
        return this.properties.containsKey(propertyName);
    }

    public FolderServiceDecorator put(String propertyName, Object propertyValue) {
        if (null == propertyName || null == propertyValue) {
            return this;
        }
        this.properties.put(propertyName, propertyValue);
        return this;
    }

    public FolderServiceDecorator remove(String propertyName) {
        this.properties.remove(propertyName);
        return this;
    }

    public FolderServiceDecorator putProperties(Map<? extends String, ? extends Object> properties) {
        if (null != properties) {
            this.properties.putAll(properties);
        }
        return this;
    }

    public Object getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public boolean getBoolProperty(String name) {
        if (null == name) {
            return false;
        }
        Object value = this.properties.get(name);
        return null != value && BOOL_VALS.contains(value.toString().trim().toLowerCase(Locale.ENGLISH));
    }

    public boolean isHandDownPermissions() {
        Object permissionsHandling = this.properties.get("permissions");
        return null != permissionsHandling && "inherit".equalsIgnoreCase(permissionsHandling.toString());
    }

    public Map<String, Object> getProperties() {
        return new HashMap<String, Object>(this.properties);
    }
}

