/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.event.impl;

import com.openexchange.config.ConfigurationService;
import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.event.impl.EventConfigImpl;
import com.openexchange.event.impl.EventQueue;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentCleaner;
import com.openexchange.groupware.impl.FolderLockManagerImpl;
import com.openexchange.groupware.infostore.webdav.EntityLockManagerImpl;
import com.openexchange.groupware.infostore.webdav.LockCleaner;
import com.openexchange.groupware.infostore.webdav.PropertyCleaner;
import com.openexchange.groupware.infostore.webdav.PropertyStoreImpl;
import com.openexchange.groupware.notify.ParticipantNotify;
import com.openexchange.server.Initialization;
import com.openexchange.server.services.ServerServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventInit
implements Initialization {
    private static final Logger LOG = LoggerFactory.getLogger(EventInit.class);
    private boolean started;

    public void start() throws OXException {
        if (this.started) {
            return;
        }
        this.started = true;
        boolean infoEnabled = LOG.isInfoEnabled();
        if (infoEnabled) {
            LOG.info("Parse Event properties");
        }
        EventConfigImpl eventConfig = new EventConfigImpl(ServerServiceRegistry.getInstance().getService(ConfigurationService.class).getFileByName("event.properties"));
        EventQueue.init(eventConfig);
        if (infoEnabled) {
            LOG.info("Adding Notification Listener");
        }
        ParticipantNotify notify = new ParticipantNotify();
        EventQueue.addModernListener(notify);
        EventQueue.addModernListener(notify);
        if (infoEnabled) {
            LOG.info("Adding AttachmentCleaner");
        }
        AttachmentCleaner attCleaner = new AttachmentCleaner();
        EventQueue.addAppointmentEvent(attCleaner);
        EventQueue.addContactEvent(attCleaner);
        EventQueue.addTaskEvent(attCleaner);
        if (infoEnabled) {
            LOG.info("Adding PropertiesCleaner");
        }
        PropertyCleaner propertyCleaner = new PropertyCleaner(new PropertyStoreImpl(new DBPoolProvider(), "oxfolder_property"), new PropertyStoreImpl(new DBPoolProvider(), "infostore_property"));
        EventQueue.addFolderEvent(propertyCleaner);
        if (infoEnabled) {
            LOG.info("Adding LockCleaner");
        }
        LockCleaner lockCleaner = new LockCleaner(new FolderLockManagerImpl(new DBPoolProvider()), new EntityLockManagerImpl(new DBPoolProvider(), "infostore_lock"));
        EventQueue.addFolderEvent(lockCleaner);
    }

    public void stop() throws OXException {
        EventQueue.stop();
        EventQueue.clearAllListeners();
    }
}

