/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.config.json;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXActionServiceFactory;
import com.openexchange.config.json.actions.GETAction;
import com.openexchange.config.json.actions.PUTAction;
import com.openexchange.documentation.annotations.Module;
import com.openexchange.exception.OXException;
import com.openexchange.server.ServiceLookup;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Module(name="config", description="The config module is used to retrieve and set user-specific configuration.")
public class ConfigActionFactory
implements AJAXActionServiceFactory {
    private final Map<String, AJAXActionService> actions = new ConcurrentHashMap<String, AJAXActionService>(2);

    public ConfigActionFactory(ServiceLookup services) {
        this.actions.put("GET", new GETAction(services));
        this.actions.put("PUT", new PUTAction(services));
    }

    @Override
    public AJAXActionService createActionService(String action) throws OXException {
        return this.actions.get(action);
    }

    public Collection<? extends AJAXActionService> getSupportedServices() {
        return Collections.unmodifiableCollection(this.actions.values());
    }
}

