/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.converters.preview.PreviewDocumentCallable;
import com.openexchange.exception.OXException;
import com.openexchange.preview.PreviewDocument;
import com.openexchange.preview.PreviewExceptionCodes;
import com.openexchange.preview.PreviewOutput;
import com.openexchange.preview.PreviewService;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.tools.session.ServerSession;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreviewImageGenerator
extends FutureTask<PreviewDocument> {
    private static final Logger LOG = LoggerFactory.getLogger(PreviewImageGenerator.class);
    private final PreviewDocumentCallable callable;
    private static final ConcurrentMap<String, PreviewImageGenerator> RUNNING = new ConcurrentHashMap<String, PreviewImageGenerator>(32);

    public PreviewImageGenerator(PreviewDocumentCallable callable) {
        super(callable);
        this.callable = callable;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        try {
            this.callable.interrupt();
        }
        catch (IOException ioe) {
            LOG.error("Error while trying to cancel.", (Throwable)ioe);
        }
        return super.cancel(mayInterruptIfRunning);
    }

    public long getAwaitThreshold(long defaultThreshold) {
        return this.callable == null ? defaultThreshold : this.callable.getAwaitThreshold(defaultThreshold);
    }

    public static PreviewDocument getPreviewDocument(AJAXRequestResult result, AJAXRequestData requestData, ServerSession session, PreviewService previewService, long threshold, boolean respectLanguage) throws OXException {
        return PreviewImageGenerator.getPreviewDocument(result, requestData, session, previewService, threshold, respectLanguage, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PreviewDocument getPreviewDocument(AJAXRequestResult result, AJAXRequestData requestData, ServerSession session, PreviewService previewService, long threshold, boolean respectLanguage, String cacheKey) throws OXException {
        if (cacheKey != null) {
            boolean removeFromRunning = false;
            try {
                PreviewImageGenerator newFuture;
                PreviewImageGenerator previewFuture = (PreviewImageGenerator)RUNNING.get(cacheKey);
                if (null == previewFuture && null == (previewFuture = RUNNING.putIfAbsent(cacheKey, newFuture = new PreviewImageGenerator(new PreviewDocumentCallable(result, requestData, PreviewOutput.IMAGE, session, previewService, respectLanguage))))) {
                    previewFuture = newFuture;
                    ThreadPools.getExecutorService().execute(previewFuture);
                    removeFromRunning = true;
                }
                PreviewDocument previewDocument = removeFromRunning ? PreviewImageGenerator.getFrom(previewFuture, threshold) : null;
                return previewDocument;
            }
            finally {
                if (removeFromRunning) {
                    RUNNING.remove(cacheKey);
                }
            }
        }
        PreviewImageGenerator previewFuture = new PreviewImageGenerator(new PreviewDocumentCallable(result, requestData, PreviewOutput.IMAGE, session, previewService, respectLanguage));
        ThreadPools.getExecutorService().execute(previewFuture);
        return PreviewImageGenerator.getFrom(previewFuture, threshold);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PreviewDocument getFrom(PreviewImageGenerator previewFuture, long threshold) throws OXException {
        boolean error = true;
        try {
            PreviewDocument previewDocument = (PreviewDocument)previewFuture.get(previewFuture.getAwaitThreshold(threshold), TimeUnit.MILLISECONDS);
            error = false;
            PreviewDocument previewDocument2 = previewDocument;
            return previewDocument2;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw PreviewExceptionCodes.ERROR.create((Throwable)ie, new Object[]{ie.getMessage()});
        }
        catch (ExecutionException ee) {
            throw (OXException)((Object)ThreadPools.launderThrowable((ExecutionException)ee, OXException.class));
        }
        catch (TimeoutException te) {
            PreviewDocument previewDocument = null;
            return previewDocument;
        }
        finally {
            if (error) {
                previewFuture.cancel(true);
            }
        }
    }
}

