/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.login;

import com.openexchange.config.ConfigurationService;
import com.openexchange.java.Charsets;
import com.openexchange.java.Strings;
import com.openexchange.tools.HashUtility;
import com.openexchange.tools.encoding.Base64;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashCalculator {
    private static final Logger LOG = LoggerFactory.getLogger(HashCalculator.class);
    private static final String USER_AGENT = "clientUserAgent";
    private static final String CLIENT_PARAM = "client";
    private static final Pattern PATTERN_NON_WORD_CHAR = Pattern.compile("\\W");
    private static final HashCalculator SINGLETON = new HashCalculator();
    private volatile String[] fields = new String[0];
    private volatile byte[] salt = new byte[0];

    public static HashCalculator getInstance() {
        return SINGLETON;
    }

    private HashCalculator() {
    }

    public void configure(ConfigurationService service) {
        if (null != service) {
            String fieldList = service.getProperty("com.openexchange.cookie.hash.fields", "");
            this.fields = Pattern.compile("\\s*,\\s*").split(fieldList, 0);
            this.salt = service.getProperty("com.openexchange.cookie.hash.salt", "replaceMe1234567890").getBytes();
        }
    }

    public String getHash(HttpServletRequest req, String client) {
        return this.getHash(req, HashCalculator.getUserAgent(req), client);
    }

    public String getHash(HttpServletRequest req, String userAgent, String client) {
        try {
            byte[] salt;
            String[] fields;
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update((null == userAgent ? HashCalculator.parseClientUserAgent(req, "") : userAgent).getBytes(Charsets.UTF_8));
            if (null != client) {
                md.update(client.getBytes(Charsets.UTF_8));
            }
            if (null != (fields = this.fields)) {
                for (String field : fields) {
                    String header = req.getHeader(field);
                    if (Strings.isEmpty((String)header)) continue;
                    md.update(header.getBytes(Charsets.UTF_8));
                }
            }
            if (null != (salt = this.salt)) {
                md.update(salt);
            }
            return PATTERN_NON_WORD_CHAR.matcher(Base64.encode(md.digest())).replaceAll("");
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("", (Throwable)e);
            return "";
        }
    }

    public String getHash(HttpServletRequest req) {
        return this.getHash(req, HashCalculator.getClient(req));
    }

    public static String getClient(HttpServletRequest req) {
        String parameter = req.getParameter(CLIENT_PARAM);
        return Strings.isEmpty((String)parameter) ? "default" : parameter;
    }

    public String getUserAgentHash(HttpServletRequest req) {
        return this.getUserAgentHash(req, null);
    }

    public String getUserAgentHash(HttpServletRequest req, String userAgent) {
        String md5 = HashUtility.getMD5(null == userAgent ? HashCalculator.getUserAgent(req) : userAgent, "hex");
        return null == md5 ? "" : md5;
    }

    private static String parseClientUserAgent(HttpServletRequest req, String defaultValue) {
        String parameter = req.getParameter(USER_AGENT);
        return Strings.isEmpty((String)parameter) ? defaultValue : parameter;
    }

    public static String getUserAgent(HttpServletRequest req) {
        String header = req.getHeader("user-agent");
        if (header == null) {
            return "";
        }
        return header;
    }
}

