/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.fields;

import com.openexchange.groupware.search.Order;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public final class OrderFields {
    private static final Map<Order, String> WRITE_MAP = new EnumMap<Order, String>(Order.class);
    private static final Map<String, Order> PARSE_MAP;

    private OrderFields() {
    }

    public static String write(Order order) {
        String retval;
        switch (order) {
            case NO_ORDER: {
                retval = null;
                break;
            }
            default: {
                retval = WRITE_MAP.get((Object)order);
            }
        }
        return retval;
    }

    public static Order parse(String order) {
        Order retval = null == order || !PARSE_MAP.containsKey(order) ? Order.NO_ORDER : PARSE_MAP.get(order);
        return retval;
    }

    static {
        WRITE_MAP.put(Order.ASCENDING, "asc");
        WRITE_MAP.put(Order.DESCENDING, "desc");
        Order[] values = Order.values();
        HashMap<String, Order> tmp = com.openexchange.tools.Collections.newHashMap(values.length);
        for (Order order : values) {
            tmp.put(WRITE_MAP.get((Object)order), order);
        }
        PARSE_MAP = Collections.unmodifiableMap(tmp);
    }
}

