/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.DataServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.request.AppointmentRequest;
import com.openexchange.exception.OXException;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Appointment
extends DataServlet {
    private static final long serialVersionUID = 8550664916596120436L;
    private static final transient Logger LOG = LoggerFactory.getLogger(Appointment.class);

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ServerSession session = this.getSessionObject((ServletRequest)httpServletRequest);
        Response response = new Response(session);
        try {
            JSONObject jsonObj;
            String action = Appointment.parseMandatoryStringParameter(httpServletRequest, "action");
            try {
                jsonObj = Appointment.convertParameter2JSONObject(httpServletRequest);
            }
            catch (JSONException e) {
                LOG.error("", (Throwable)e);
                response.setException(OXJSONExceptionCodes.JSON_BUILD_ERROR.create(e, new Object[0]));
                this.writeResponse(response, httpServletResponse, session);
                return;
            }
            AppointmentRequest appointmentRequest = new AppointmentRequest(session);
            JSONValue responseObj = appointmentRequest.action(action, jsonObj);
            response.setTimestamp(appointmentRequest.getTimestamp());
            response.setData(responseObj);
        }
        catch (OXException e) {
            e.log(LOG);
            response.setException(e);
        }
        catch (JSONException e) {
            OXException oje = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error("", (Throwable)oje);
            response.setException(oje);
        }
        this.writeResponse(response, httpServletResponse, session);
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Response response;
        block10: {
            ServerSession session = this.getSessionObject((ServletRequest)httpServletRequest);
            response = new Response(session);
            try {
                String action = Appointment.parseMandatoryStringParameter(httpServletRequest, "action");
                String data = Appointment.getBody(httpServletRequest).trim();
                if (data.length() > 0) {
                    JSONObject jsonObj;
                    try {
                        jsonObj = Appointment.convertParameter2JSONObject(httpServletRequest);
                    }
                    catch (JSONException e) {
                        LOG.error("", (Throwable)e);
                        response.setException(OXJSONExceptionCodes.JSON_BUILD_ERROR.create(e, new Object[0]));
                        this.writeResponse(response, httpServletResponse, this.getSessionObject((ServletRequest)httpServletRequest));
                        return;
                    }
                    AppointmentRequest appointmentRequest = new AppointmentRequest(session);
                    if (data.charAt(0) == '[') {
                        JSONArray jsonDataArray = new JSONArray(data);
                        jsonObj.put("data", (Object)jsonDataArray);
                        JSONValue responseObj = appointmentRequest.action(action, jsonObj);
                        response.setTimestamp(appointmentRequest.getTimestamp());
                        response.setData(responseObj);
                    } else if (data.charAt(0) == '{') {
                        JSONObject jsonDataObject = new JSONObject(data);
                        jsonObj.put("data", (Object)jsonDataObject);
                        JSONValue responseObj = appointmentRequest.action(action, jsonObj);
                        response.setTimestamp(appointmentRequest.getTimestamp());
                        response.setData(responseObj);
                    } else {
                        httpServletResponse.sendError(400, "invalid json object");
                    }
                    break block10;
                }
                httpServletResponse.sendError(400, "no data found");
            }
            catch (JSONException e) {
                OXException oje = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
                LOG.error("", (Throwable)oje);
                response.setException(oje);
            }
            catch (OXException e) {
                e.log(LOG);
                response.setException(e);
            }
        }
        this.writeResponse(response, httpServletResponse, this.getSessionObject((ServletRequest)httpServletRequest));
    }

    @Override
    protected boolean hasModulePermission(ServerSession session) {
        return session.getUserPermissionBits().hasCalendar();
    }
}

