/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit.valuedefinitions.rfc2445;

import com.openexchange.tools.versit.Property;
import com.openexchange.tools.versit.ReaderScanner;
import com.openexchange.tools.versit.Scanner;
import com.openexchange.tools.versit.StringScanner;
import com.openexchange.tools.versit.ValueDefinition;
import com.openexchange.tools.versit.VersitException;
import com.openexchange.tools.versit.valuedefinitions.rfc2425.ListValueDefinition;
import com.openexchange.tools.versit.valuedefinitions.rfc2445.TextValueDefinition;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ListValueDefinitionTest {
    private ValueDefinition listValueDefinition;

    @Before
    public void setUp() throws Exception {
        this.listValueDefinition = new ListValueDefinition(new Character(';').charValue(), (ValueDefinition)new TextValueDefinition());
    }

    @Test
    public void testCreateValue_adressLineProvided_returnLine() throws IOException {
        String text = ";;c/o BESSY\r\nAlbert-Einstein-Strasse 15;Berlin;;12489;Deutschland";
        List createValue = (List)this.listValueDefinition.createValue(new StringScanner((Scanner)new ReaderScanner((Reader)new InputStreamReader(new ByteArrayInputStream(text.getBytes()))), text), new Property("ADR"));
        String join = StringUtils.join((Collection)createValue, (char)';');
        Assert.assertEquals((Object)text, (Object)join);
    }

    @Test
    public void testCreateValue_adressWithEscaeRProvided_returnLineWithEscapedR() throws IOException {
        String text = ";;c/o BESSY\r\nAlbert-Einstein-Strasse 15;Berlin;;12489;Deutschland";
        List createValue = (List)this.listValueDefinition.createValue(new StringScanner((Scanner)new ReaderScanner((Reader)new InputStreamReader(new ByteArrayInputStream(text.getBytes()))), text), new Property("ADR"));
        String join = StringUtils.join((Collection)createValue, (char)';');
        Assert.assertTrue((boolean)join.contains("\r"));
    }

    @Test(expected=VersitException.class)
    public void testCreateValue_invalidEscapeSequence_throwException() throws IOException {
        String text = ";;c/o BESSY\\z\nAlbert-Einstein-Strasse 15;Berlin;;12489;Deutschland";
        this.listValueDefinition.createValue(new StringScanner((Scanner)new ReaderScanner((Reader)new InputStreamReader(new ByteArrayInputStream(text.getBytes()))), text), new Property("ADR"));
    }
}

