/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server.services;

import com.openexchange.configuration.ServerConfig;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentConfig;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.filestore.FilestoreStorage;
import com.openexchange.groupware.infostore.InfostoreConfig;
import com.openexchange.jslob.JSlob;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.server.services.SharedInfostoreJSlob;
import com.openexchange.session.Session;
import com.openexchange.tools.file.QuotaFileStorage;
import java.net.URI;
import org.json.JSONException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={InfostoreConfig.class, ServerConfig.class, AttachmentConfig.class, ContextStorage.class, QuotaFileStorage.class, UserSettingMailStorage.class, UserSettingMail.class, FilestoreStorage.class})
public class SharedInfostoreJSlobTest {
    @InjectMocks
    private SharedInfostoreJSlob sharedInfostoreJSlob;
    @Mock
    private Session session;
    @Mock
    private QuotaFileStorage quotaFileStorage;
    private Context context = new ContextImpl(999999);
    private int maxBodySize = 11111;
    private Long infostoreMaxUploadSize = 22222L;
    private Long attachmentMaxUploadSize = 33333L;
    private Long quotaUsage = 44444L;
    private Long maxQuota = 55555L;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        PowerMockito.mockStatic(ServerConfig.class, (Class[])new Class[0]);
        PowerMockito.when((Object)ServerConfig.getInt((ServerConfig.Property)((ServerConfig.Property)Matchers.any()))).thenReturn((Object)this.maxBodySize);
        PowerMockito.mockStatic(InfostoreConfig.class, (Class[])new Class[0]);
        PowerMockito.when((Object)InfostoreConfig.getMaxUploadSize()).thenReturn((Object)this.infostoreMaxUploadSize);
        PowerMockito.mockStatic(AttachmentConfig.class, (Class[])new Class[0]);
        PowerMockito.when((Object)AttachmentConfig.getMaxUploadSize()).thenReturn((Object)this.attachmentMaxUploadSize);
        PowerMockito.mockStatic(FilestoreStorage.class, (Class[])new Class[0]);
        PowerMockito.when((Object)FilestoreStorage.createURI((Context)((Context)Matchers.eq((Object)this.context)))).thenReturn((Object)new URI(""));
        PowerMockito.mockStatic(ContextStorage.class, (Class[])new Class[0]);
        PowerMockito.when((Object)ContextStorage.getStorageContext((Session)this.session)).thenReturn((Object)this.context);
        PowerMockito.mockStatic(QuotaFileStorage.class, (Class[])new Class[0]);
        PowerMockito.when((Object)QuotaFileStorage.getInstance((URI)((URI)Matchers.any()), (Context)((Context)Matchers.eq((Object)this.context)))).thenReturn((Object)this.quotaFileStorage);
        PowerMockito.when((Object)this.quotaFileStorage.getQuota()).thenReturn((Object)this.maxQuota);
        PowerMockito.when((Object)this.quotaFileStorage.getUsage()).thenReturn((Object)this.quotaUsage);
        PowerMockito.mockStatic(UserSettingMailStorage.class, (Class[])new Class[0]);
        UserSettingMailStorage userSettingMailStorage = (UserSettingMailStorage)Mockito.mock(UserSettingMailStorage.class);
        PowerMockito.when((Object)UserSettingMailStorage.getInstance()).thenReturn((Object)userSettingMailStorage);
        UserSettingMail userSettingMail = (UserSettingMail)Mockito.mock(UserSettingMail.class);
        PowerMockito.when((Object)userSettingMailStorage.getUserSettingMail(Matchers.anyInt(), (Context)Matchers.eq((Object)Matchers.eq((Object)this.context)))).thenReturn((Object)userSettingMail);
    }

    @Test
    public void testGetJSlob_fine_maxBodySizeSet() throws OXException, JSONException {
        JSlob jSlob = this.sharedInfostoreJSlob.getJSlob(this.session);
        Assert.assertEquals((Object)this.maxBodySize, (Object)jSlob.getJsonObject().get("maxBodySize"));
    }

    @Test
    public void testGetJSlob_fine_infostoreMaxUploadSizeSet() throws OXException, JSONException {
        JSlob jSlob = this.sharedInfostoreJSlob.getJSlob(this.session);
        Assert.assertEquals((Object)this.infostoreMaxUploadSize, (Object)jSlob.getJsonObject().get("infostoreMaxUploadSize"));
    }

    @Test
    public void testGetJSlob_fine_attachmentMaxUploadSizeSet() throws OXException, JSONException {
        JSlob jSlob = this.sharedInfostoreJSlob.getJSlob(this.session);
        Assert.assertEquals((Object)this.attachmentMaxUploadSize, (Object)jSlob.getJsonObject().get("attachmentMaxUploadSize"));
    }

    @Test
    public void testGetJSlob_fine_infostoreQuotaSet() throws OXException, JSONException {
        JSlob jSlob = this.sharedInfostoreJSlob.getJSlob(this.session);
        Assert.assertEquals((Object)this.maxQuota, (Object)jSlob.getJsonObject().get("infostoreQuota"));
    }

    @Test
    public void testGetJSlob_fine_infostoreUsageSet() throws OXException, JSONException {
        JSlob jSlob = this.sharedInfostoreJSlob.getJSlob(this.session);
        Assert.assertEquals((Object)this.quotaUsage, (Object)jSlob.getJsonObject().get("infostoreUsage"));
    }

    @Test
    public void testGetJSlob_fine_attachmentQuotaSet() throws OXException, JSONException {
        JSlob jSlob = this.sharedInfostoreJSlob.getJSlob(this.session);
        Assert.assertEquals((Object)0L, (Object)jSlob.getJsonObject().get("attachmentQuota"));
    }

    @Test
    public void testGetJSlob_fine_attachmentQuotaPerFileSet() throws OXException, JSONException {
        JSlob jSlob = this.sharedInfostoreJSlob.getJSlob(this.session);
        Assert.assertEquals((Object)-1L, (Object)jSlob.getJsonObject().get("attachmentQuotaPerFile"));
    }
}

