/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.groupware.upload.impl.UploadEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;
import org.json.JSONObject;
import org.junit.runner.RunWith;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
public class ProcessUploadStaticTest
extends TestCase {
    public void testProcessUploadStatic() {
        try {
            final CountDownLatch startUpLatch = new CountDownLatch(1);
            int threadCount = 100;
            final CountDownLatch finishedLatch = new CountDownLatch(100);
            for (int i = 0; i < 100; ++i) {
                final int num = i + 1;
                Runnable r = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            HttpServletRequest mockRequest = (HttpServletRequest)PowerMockito.mock(HttpServletRequest.class);
                            final ByteArrayInputStream bin = new ByteArrayInputStream(("-----------------------------1902770288168124293960248547\r\nContent-Disposition: form-data; name=\"json_0\"\r\n\r\n{\"from\":\"Thorben Betten <thorben@devel-mail.netline.de>\",\"to\":\"Thorben Betten <thorben@devel-mail.netline.de>\",\"cc\":\"\",\"bcc\":\"\",\"subject\":\"Subject\",\"priority\":\"3\",\"vcard\":1,\"attachments\":[{\"content_type\":\"ALTERNATIVE\",\"content\":\"<html><body>&gt;Content" + num + "&lt;</body></html>\"}],\"datasources\":[]}\r\n-----------------------------1902770288168124293960248547--").getBytes());
                            ServletInputStream in = new ServletInputStream(){

                                public int read() throws IOException {
                                    return bin.read();
                                }
                            };
                            PowerMockito.when((Object)mockRequest.getInputStream()).thenReturn((Object)in);
                            PowerMockito.when((Object)mockRequest.getContentType()).thenReturn((Object)"multipart/form-data; boundary=---------------------------1902770288168124293960248547");
                            PowerMockito.when((Object)mockRequest.getContentLength()).thenReturn((Object)-1);
                            PowerMockito.when((Object)mockRequest.getCharacterEncoding()).thenReturn((Object)"UTF-8");
                            PowerMockito.when((Object)mockRequest.getParameter("action")).thenReturn((Object)"new");
                            startUpLatch.await();
                            UploadEvent uploadEvent = AJAXServlet.processUploadStatic((HttpServletRequest)mockRequest);
                            TestCase.assertEquals((String)"Unexpected number of form fields", (int)1, (int)uploadEvent.getNumberOfFormFields());
                            JSONObject jo = new JSONObject(uploadEvent.getFormField("json_0"));
                            TestCase.assertEquals((String)"Unexpected form field content", (String)("<html><body>&gt;Content" + num + "&lt;</body></html>"), (String)jo.getJSONArray("attachments").getJSONObject(0).getString("content"));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestCase.fail((String)e.getMessage());
                        }
                        finally {
                            finishedLatch.countDown();
                        }
                    }
                };
                new Thread(r).start();
            }
            startUpLatch.countDown();
            finishedLatch.await();
        }
        catch (Exception e) {
            e.printStackTrace();
            ProcessUploadStaticTest.fail((String)e.getMessage());
        }
    }

    public void testProcessUploadStatic2() {
        try {
            HttpServletRequest mockRequest = (HttpServletRequest)PowerMockito.mock(HttpServletRequest.class);
            final ByteArrayInputStream bin = new ByteArrayInputStream("-----------------------------1902770288168124293960248547\r\nContent-Disposition: form-data; name=\"json_0\"\r\n\r\n{\"from\":\"Thorben Betten <thorben@devel-mail.netline.de>\",\"to\":\"Thorben Betten <thorben@devel-mail.netline.de>\",\"cc\":\"\",\"bcc\":\"\",\"subject\":\"Subject\",\"priority\":\"3\",\"vcard\":1,\"attachments\":[{\"content_type\":\"ALTERNATIVE\",\"content\":\"<html><body>&gt;Content1&lt;</body></html>\"}],\"datasources\":[]}\r\n-----------------------------1902770288168124293960248547\r\nContent-Disposition: form-data; name=\"json_0\"\r\n\r\n{\"from\":\"Thorben Betten <thorben@devel-mail.netline.de>\",\"to\":\"Thorben Betten <thorben@devel-mail.netline.de>\",\"cc\":\"\",\"bcc\":\"\",\"subject\":\"Subject\",\"priority\":\"3\",\"vcard\":1,\"attachments\":[{\"content_type\":\"ALTERNATIVE\",\"content\":\"<html><body>&gt;Content2&lt;</body></html>\"}],\"datasources\":[]}\r\n-----------------------------1902770288168124293960248547--".getBytes());
            ServletInputStream in = new ServletInputStream(){

                public int read() throws IOException {
                    return bin.read();
                }
            };
            PowerMockito.when((Object)mockRequest.getInputStream()).thenReturn((Object)in);
            PowerMockito.when((Object)mockRequest.getContentType()).thenReturn((Object)"multipart/form-data; boundary=---------------------------1902770288168124293960248547");
            PowerMockito.when((Object)mockRequest.getContentLength()).thenReturn((Object)-1);
            PowerMockito.when((Object)mockRequest.getCharacterEncoding()).thenReturn((Object)"UTF-8");
            PowerMockito.when((Object)mockRequest.getParameter("action")).thenReturn((Object)"new");
            UploadEvent uploadEvent = AJAXServlet.processUploadStatic((HttpServletRequest)mockRequest);
            ProcessUploadStaticTest.assertEquals((String)"Unexpected number of form fields", (int)1, (int)uploadEvent.getNumberOfFormFields());
            JSONObject jo = new JSONObject(uploadEvent.getFormField("json_0"));
            ProcessUploadStaticTest.assertEquals((String)"Unexpected form field content", (String)"<html><body>&gt;Content2&lt;</body></html>", (String)jo.getJSONArray("attachments").getJSONObject(0).getString("content"));
        }
        catch (Exception e) {
            e.printStackTrace();
            ProcessUploadStaticTest.fail((String)e.getMessage());
        }
    }
}

