/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi;

import com.openexchange.osgi.ServiceProvider;
import java.util.Set;
import java.util.TreeSet;

public class DefaultServiceProvider<S>
implements ServiceProvider<S> {
    private final Set<RankedService<S>> set = new TreeSet<RankedService<S>>();

    @Override
    public S getService() {
        return this.set.isEmpty() ? null : (S)this.set.iterator().next().service;
    }

    @Override
    public void addService(S service, int ranking) {
        this.set.add(new RankedService<S>(service, ranking));
    }

    private static final class RankedService<S>
    implements Comparable<RankedService<S>> {
        protected final int ranking;
        protected final S service;

        protected RankedService(S service, int ranking) {
            this.service = service;
            this.ranking = ranking;
        }

        @Override
        public int compareTo(RankedService<S> o) {
            int thisVal = this.ranking;
            int anotherVal = o.ranking;
            return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
        }
    }
}

