/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.messaging.generic.internet;

import com.openexchange.exception.OXException;
import com.openexchange.mail.mime.ParameterizedHeader;
import com.openexchange.messaging.ContentType;
import com.openexchange.messaging.MessagingHeader;
import java.util.ArrayList;
import java.util.Iterator;

public final class MimeContentType
extends com.openexchange.messaging.generic.internal.ParameterizedHeader
implements ContentType {
    private static final long serialVersionUID = 8048448895301469418L;
    private static final String CONTENT_TYPE = "Content-Type";
    public static final MimeContentType DEFAULT_CONTENT_TYPE = new MimeContentType(com.openexchange.mail.mime.ContentType.DEFAULT_CONTENT_TYPE);
    private final com.openexchange.mail.mime.ContentType cto;

    public static String getContentTypeName() {
        return CONTENT_TYPE;
    }

    public MimeContentType() {
        super((ParameterizedHeader)new com.openexchange.mail.mime.ContentType());
        this.cto = (com.openexchange.mail.mime.ContentType)this.delegate;
    }

    public MimeContentType(String contentType) throws OXException {
        super((ParameterizedHeader)MimeContentType.toContentType(contentType));
        this.cto = (com.openexchange.mail.mime.ContentType)this.delegate;
    }

    private MimeContentType(com.openexchange.mail.mime.ContentType cto) {
        super((ParameterizedHeader)cto);
        this.cto = cto;
    }

    private static com.openexchange.mail.mime.ContentType toContentType(String contentType) throws OXException {
        return new com.openexchange.mail.mime.ContentType(contentType);
    }

    @Override
    public int compareTo(com.openexchange.messaging.generic.internal.ParameterizedHeader other) {
        int baseComp;
        if (this == other) {
            return 0;
        }
        if (MimeContentType.class.isInstance(other) && (baseComp = this.getBaseType().compareToIgnoreCase(((MimeContentType)other).getBaseType())) != 0) {
            return baseComp;
        }
        return super.compareTo(other);
    }

    @Override
    public int hashCode() {
        return this.cto.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MimeContentType other = (MimeContentType)obj;
        return !(this.cto == null ? other.cto != null : !this.cto.equals((Object)other.cto));
    }

    public void setContentType(ContentType contentType) {
        if (contentType == this) {
            return;
        }
        if (contentType instanceof MimeContentType) {
            this.cto.setContentType(((MimeContentType)contentType).cto);
        } else {
            this.cto.setPrimaryType(contentType.getPrimaryType());
            this.cto.setSubType(contentType.getSubType());
            ArrayList tmp = new ArrayList(4);
            Iterator it = this.cto.getParameterNames();
            while (it.hasNext()) {
                tmp.add(it.next());
            }
            for (String name : tmp) {
                this.cto.removeParameter(name);
            }
            Iterator it2 = contentType.getParameterNames();
            while (it2.hasNext()) {
                String name = (String)it2.next();
                this.cto.addParameter(name, contentType.getParameter(name));
            }
        }
    }

    public String getName() {
        return CONTENT_TYPE;
    }

    @Override
    public MessagingHeader.HeaderType getHeaderType() {
        return MessagingHeader.HeaderType.PARAMETERIZED;
    }

    public String getValue() {
        return this.toString();
    }

    public void setContentType(MimeContentType contentType) {
        if (contentType == this) {
            return;
        }
        this.cto.setContentType(contentType.cto);
    }

    public String getPrimaryType() {
        return this.cto.getPrimaryType();
    }

    public void setPrimaryType(String primaryType) {
        this.cto.setPrimaryType(primaryType);
    }

    public String getSubType() {
        return this.cto.getSubType();
    }

    public void setSubType(String subType) {
        this.cto.setSubType(subType);
    }

    public String getBaseType() {
        return this.cto.getBaseType();
    }

    public void setBaseType(String baseType) throws OXException {
        this.cto.setBaseType(baseType);
    }

    public void setCharsetParameter(String charset) {
        this.cto.setCharsetParameter(charset);
    }

    public String getCharsetParameter() {
        return this.cto.getCharsetParameter();
    }

    public boolean containsCharsetParameter() {
        return this.cto.containsCharsetParameter();
    }

    public void setNameParameter(String filename) {
        this.cto.setNameParameter(filename);
    }

    public String getNameParameter() {
        return this.cto.getNameParameter();
    }

    public boolean containsNameParameter() {
        return this.cto.containsNameParameter();
    }

    public void setContentType(String contentType) throws OXException {
        this.cto.setContentType(contentType);
    }

    public boolean isMimeType(String pattern) {
        return this.cto.isMimeType(pattern);
    }

    public boolean startsWith(String prefix) {
        return this.cto.startsWith(prefix);
    }

    public static String prepareContentTypeString(String contentType) throws OXException {
        return com.openexchange.mail.mime.ContentType.prepareContentTypeString((String)contentType);
    }

    public static String prepareContentTypeString(String contentType, String name) throws OXException {
        return com.openexchange.mail.mime.ContentType.prepareContentTypeString((String)contentType, (String)name);
    }

    public static boolean isMimeType(String mimeType, String pattern) throws OXException {
        return com.openexchange.mail.mime.ContentType.isMimeType((String)mimeType, (String)pattern);
    }

    public static String getBaseType(String mimeType) throws OXException {
        return com.openexchange.mail.mime.ContentType.getBaseType((String)mimeType);
    }

    public String toString() {
        return this.cto.toString();
    }

    public String toString(boolean skipEmptyParams) {
        return this.cto.toString(skipEmptyParams);
    }
}

