/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import java.util.LinkedList;
import java.util.List;

public class SimpleTokenizer {
    public static List<String> tokenize(List<String> queries) {
        LinkedList<String> tokens = new LinkedList<String>();
        for (String query : queries) {
            SimpleTokenizer.tokenize(tokens, query);
        }
        return tokens;
    }

    public static List<String> tokenize(String query) {
        LinkedList<String> tokens = new LinkedList<String>();
        SimpleTokenizer.tokenize(tokens, query);
        return tokens;
    }

    private static void tokenize(List<String> tokens, String query) {
        int lastQuotePos = -1;
        boolean inQuotes = false;
        char[] chars = query.trim().toCharArray();
        int len = chars.length;
        if (len > 0) {
            StringBuilder tokenBuilder = new StringBuilder(query.length());
            for (int i = 0; i < len; ++i) {
                char c = chars[i];
                if (c == '\"') {
                    lastQuotePos = i;
                    if (inQuotes) {
                        inQuotes = false;
                        continue;
                    }
                    inQuotes = true;
                    continue;
                }
                if (Character.isWhitespace(c)) {
                    if (inQuotes) {
                        tokenBuilder.append(' ');
                        continue;
                    }
                    tokens.add(tokenBuilder.toString());
                    tokenBuilder.setLength(0);
                    continue;
                }
                tokenBuilder.append(c);
            }
            if (inQuotes && lastQuotePos < len - 1) {
                tokens.addAll(SimpleTokenizer.tokenize(new String(chars, lastQuotePos + 1, chars.length - (lastQuotePos + 1))));
            } else {
                String token = tokenBuilder.toString();
                if (token.trim().length() > 0) {
                    tokens.add(token);
                }
            }
        }
    }
}

