/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.exception;

import com.openexchange.exception.Category;
import com.openexchange.exception.LogLevel;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionConstants;
import com.openexchange.exception.OXExceptions;
import com.openexchange.exception.internal.I18n;
import com.openexchange.session.Session;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingFormatArgumentException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OXException
extends Exception
implements OXExceptionConstants {
    private static final Logger LOG = LoggerFactory.getLogger(OXException.class);
    private static final long serialVersionUID = 2058371531364916608L;
    private static final String DELIM = "\n\t";
    private static final int SERVER_ID = new SecureRandom().nextInt();
    private static final AtomicInteger COUNTER = new AtomicInteger(0);
    private final int count;
    private final Map<String, String> properties;
    private final List<Category> categories;
    private final List<ProblematicAttribute> problematics;
    private final Map<String, Object> arguments;
    private Object[] displayArgs;
    private int code;
    private boolean lightWeight;
    private String displayMessage;
    private String logMessage;
    private Object[] logArgs;
    private String exceptionId;
    private String prefix;
    private boolean interceptable = true;
    private Generic generic;
    private OXExceptionCode exceptionCode;
    private static final ProblematicAttribute[] EMPTY_PROBLEMATICS = new ProblematicAttribute[0];
    private static final Pattern P = Pattern.compile("(\\p{L}) {2,}(\\p{L})");

    public static int getServerId() {
        return SERVER_ID;
    }

    public static OXException general(String logMessage) {
        return OXExceptions.general(logMessage);
    }

    public static OXException general(String logMessage, Throwable cause) {
        return OXExceptions.general(logMessage, cause);
    }

    public static OXException notFound(String id) {
        return OXExceptions.notFound(id);
    }

    public static OXException noPermissionForModule(String module) {
        return OXExceptions.noPermissionForModule(module);
    }

    public static OXException noPermissionForFolder() {
        return OXExceptions.noPermissionForFolder();
    }

    public static OXException mandatoryField(String name) {
        return OXExceptions.mandatoryField(name);
    }

    public static OXException mandatoryField(int code, String name) {
        return OXExceptions.mandatoryField(code, name);
    }

    public static OXException conflict() {
        return OXExceptions.conflict();
    }

    public OXException() {
        this.generic = Generic.NONE;
        this.code = 9999;
        this.count = COUNTER.incrementAndGet();
        this.properties = new HashMap<String, String>(4);
        this.arguments = new HashMap<String, Object>(4);
        this.categories = new LinkedList<Category>();
        this.displayMessage = "An error occurred inside the server which prevented it from fulfilling the request.";
        this.logMessage = null;
        this.displayArgs = MESSAGE_ARGS_EMPTY;
        this.problematics = new LinkedList<ProblematicAttribute>();
        this.lightWeight = false;
    }

    public OXException(Throwable cause) {
        super(cause);
        this.generic = Generic.NONE;
        this.code = 9999;
        this.count = COUNTER.incrementAndGet();
        this.properties = new HashMap<String, String>(4);
        this.arguments = new HashMap<String, Object>(4);
        this.categories = new LinkedList<Category>();
        this.displayMessage = "An error occurred inside the server which prevented it from fulfilling the request.";
        this.logMessage = null;
        this.displayArgs = MESSAGE_ARGS_EMPTY;
        this.problematics = new LinkedList<ProblematicAttribute>();
        this.lightWeight = false;
    }

    public OXException(OXException cloneMe) {
        this.setStackTrace(cloneMe.getStackTrace());
        this.generic = cloneMe.generic;
        this.count = cloneMe.count;
        this.code = cloneMe.code;
        this.categories = null == cloneMe.categories ? new LinkedList() : new ArrayList<Category>(cloneMe.categories);
        this.displayArgs = cloneMe.displayArgs;
        this.displayMessage = cloneMe.displayMessage;
        this.exceptionId = cloneMe.exceptionId;
        this.logMessage = cloneMe.logMessage;
        this.prefix = cloneMe.prefix;
        this.problematics = null == cloneMe.problematics ? new LinkedList() : new ArrayList<ProblematicAttribute>(cloneMe.problematics);
        this.properties = null == cloneMe.properties ? new HashMap<String, String>(4) : new HashMap<String, String>(cloneMe.properties);
        this.arguments = null == cloneMe.arguments ? new HashMap<String, Object>(4) : new HashMap<String, Object>(cloneMe.arguments);
        this.lightWeight = cloneMe.lightWeight;
    }

    public OXException(int code) {
        this.generic = Generic.NONE;
        this.count = COUNTER.incrementAndGet();
        this.properties = new HashMap<String, String>(4);
        this.arguments = new HashMap<String, Object>(4);
        this.categories = new LinkedList<Category>();
        this.code = code;
        this.displayMessage = "An error occurred inside the server which prevented it from fulfilling the request.";
        this.displayArgs = MESSAGE_ARGS_EMPTY;
        this.problematics = new LinkedList<ProblematicAttribute>();
        this.lightWeight = false;
    }

    public OXException(int code, String displayMessage, Object ... displayArgs) {
        this.generic = Generic.NONE;
        this.count = COUNTER.incrementAndGet();
        this.properties = new HashMap<String, String>(4);
        this.arguments = new HashMap<String, Object>(4);
        this.categories = new LinkedList<Category>();
        this.code = code;
        this.displayMessage = null == displayMessage ? "An error occurred inside the server which prevented it from fulfilling the request." : displayMessage;
        this.displayArgs = null == displayArgs ? MESSAGE_ARGS_EMPTY : displayArgs;
        this.problematics = new LinkedList<ProblematicAttribute>();
        this.lightWeight = false;
    }

    public OXException(int code, String displayMessage, Throwable cause, Object ... displayArgs) {
        super(cause);
        this.generic = Generic.NONE;
        this.count = COUNTER.incrementAndGet();
        this.properties = new HashMap<String, String>(4);
        this.arguments = new HashMap<String, Object>(4);
        this.categories = new LinkedList<Category>();
        this.code = code;
        this.displayMessage = null == displayMessage ? "An error occurred inside the server which prevented it from fulfilling the request." : displayMessage;
        this.displayArgs = displayArgs;
        this.problematics = new ArrayList<ProblematicAttribute>(1);
        this.lightWeight = false;
    }

    public void copyFrom(OXException e) {
        this.interceptable = e.interceptable;
        this.code = e.code;
        this.generic = e.generic;
        this.categories.clear();
        this.categories.addAll(e.getCategories());
        this.displayArgs = e.displayArgs;
        this.displayMessage = e.displayMessage;
        this.exceptionId = e.exceptionId;
        this.logMessage = e.logMessage;
        this.prefix = e.prefix;
        this.problematics.clear();
        if (null != e.problematics) {
            this.problematics.addAll(e.problematics);
        }
        this.properties.clear();
        this.properties.putAll(e.properties);
        this.arguments.clear();
        this.arguments.putAll(e.arguments);
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return this.lightWeight ? this : super.fillInStackTrace();
    }

    public Throwable getNonOXExceptionCause() {
        Throwable cause = this.getCause();
        return cause instanceof OXException ? ((OXException)cause).getNonOXExceptionCause() : cause;
    }

    public boolean equalsCode(int code, String prefix) {
        if (this.code != code) {
            return false;
        }
        if (null == prefix) {
            throw new NullPointerException("prefix is null");
        }
        return prefix.equals(this.prefix);
    }

    public int getCode() {
        return this.code;
    }

    public Generic getGeneric() {
        return this.generic;
    }

    public boolean isGeneric(Generic generic) {
        return null != generic && generic.equals((Object)this.generic);
    }

    public boolean isNotFound() {
        return Generic.NOT_FOUND.equals((Object)this.generic);
    }

    public boolean isNoPermission() {
        return Generic.NO_PERMISSION.equals((Object)this.generic);
    }

    public boolean isMandatory() {
        return Generic.MANDATORY_FIELD.equals((Object)this.generic);
    }

    public boolean isConflict() {
        return Generic.CONFLICT.equals((Object)this.generic);
    }

    public OXException markLightWeight() {
        this.lightWeight = true;
        return this;
    }

    public OXException setGeneric(Generic generic) {
        this.generic = generic;
        return this;
    }

    public OXException setLogMessage(String logMessage) {
        this.logMessage = logMessage;
        return this;
    }

    public OXException setLogMessage(String displayFormat, Object ... args) {
        if (null == displayFormat) {
            return this;
        }
        try {
            this.logMessage = String.format(Locale.US, displayFormat, args);
            this.logArgs = args;
        }
        catch (NullPointerException e) {
            this.logMessage = null;
        }
        catch (IllegalFormatException e) {
            LOG.error("Illegal format: >>{}<<, params: {}, code: {}", new Object[]{displayFormat, null == args || 0 == args.length ? "<none>" : Arrays.toString(args), this.getErrorCode(), e});
            this.logMessage = null;
        }
        return this;
    }

    public OXException setDisplayMessage(String displayMessage, Object ... displayArgs) {
        this.displayMessage = null == displayMessage ? "An error occurred inside the server which prevented it from fulfilling the request." : displayMessage;
        this.displayArgs = null == displayArgs ? MESSAGE_ARGS_EMPTY : displayArgs;
        return this;
    }

    public String getPlainLogMessage() {
        return this.logMessage;
    }

    public Object[] getLogArgs() {
        return this.logArgs;
    }

    public Object[] getDisplayArgs() {
        return this.displayArgs;
    }

    public void log(Logger log) {
        LogLevel logLevel = this.getCategories().get(0).getLogLevel();
        if (!logLevel.appliesTo(log)) {
            return;
        }
        String loggable = this.getLogMessage(logLevel, null);
        if (null == loggable) {
            return;
        }
        logLevel.log(loggable, this, log);
    }

    public String getLogMessage(LogLevel logLevel) {
        return this.getLogMessage(logLevel, null);
    }

    public String getLogMessage(LogLevel logLevel, String defaultLog) {
        if (!this.isLoggable()) {
            return defaultLog;
        }
        return this.getLogMessage();
    }

    public String getLogMessage() {
        StringBuilder sb = new StringBuilder(256).append(this.getErrorCode());
        sb.append(" Categories=");
        List<Category> cats = this.getCategories();
        sb.append(cats.get(0));
        int size = cats.size();
        for (int i = 1; i < size; ++i) {
            sb.append(',').append(cats.get(i));
        }
        sb.append(" Message=");
        if (null == this.logMessage) {
            String str = this.getDisplayMessage0(Locale.US);
            if (null == str) {
                sb.append("[Not available]");
            } else {
                sb.append('\'').append(str).append('\'');
            }
        } else {
            sb.append('\'').append(this.logMessage).append('\'');
        }
        sb.append(" exceptionID=").append(this.getExceptionId());
        if (!this.properties.isEmpty()) {
            for (String propertyName : new TreeSet<String>(this.properties.keySet())) {
                sb.append(DELIM).append(propertyName).append(": ").append(this.properties.get(propertyName));
            }
        }
        return OXException.dropSubsequentWhitespaces(sb.toString());
    }

    public String getSoleMessage() {
        StringBuilder sb = new StringBuilder(256);
        String logMessage = this.logMessage;
        if (null == logMessage) {
            String str = this.getDisplayMessage0(Locale.US);
            if (null == str) {
                sb.append("[Not available]");
            } else {
                sb.append(str);
            }
        } else {
            sb.append(logMessage);
        }
        return OXException.dropSubsequentWhitespaces(sb.toString());
    }

    @Deprecated
    public boolean isLoggable() {
        return true;
    }

    public Category getCategory() {
        return this.getCategories().get(0);
    }

    public List<Category> getCategories() {
        if (this.categories.isEmpty()) {
            return Collections.singletonList(CATEGORY_ERROR);
        }
        if (1 == this.categories.size()) {
            return Collections.unmodifiableList(this.categories);
        }
        OXException.sortCategories(this.categories);
        return Collections.unmodifiableList(this.categories);
    }

    public static void sortCategories(List<Category> categories) {
        List<ComparableCategory> comparables = OXException.toComparables(categories);
        Collections.sort(comparables);
        categories.clear();
        for (ComparableCategory comparable : comparables) {
            if (null == comparable) continue;
            categories.add(comparable.category);
        }
    }

    private static List<ComparableCategory> toComparables(List<Category> categories) {
        ArrayList<ComparableCategory> ret = new ArrayList<ComparableCategory>(categories.size());
        for (Category category : categories) {
            if (null == category) continue;
            ret.add(new ComparableCategory(category));
        }
        return ret;
    }

    public final OXException addCategory(Category category) {
        if (null != category) {
            if (this.categories.isEmpty() && Category.EnumType.TRY_AGAIN.equals(category.getType()) && "An error occurred inside the server which prevented it from fulfilling the request.".equals(this.displayMessage)) {
                this.displayMessage = "A temporary error occurred inside the server which prevented it from fulfilling the request. Please try again later.";
            }
            this.categories.add(category);
        }
        return this;
    }

    public OXException setCategory(Category category) {
        if (null != category) {
            this.categories.clear();
            this.categories.add(category);
        }
        return this;
    }

    public void removeCategory(Category category) {
        this.categories.remove(category);
    }

    public String getExceptionId() {
        if (this.exceptionId == null) {
            this.exceptionId = new StringBuilder(16).append(SERVER_ID).append('-').append(this.count).toString();
        }
        return this.exceptionId;
    }

    public void setExceptionId(String exceptionId) {
        this.exceptionId = exceptionId;
    }

    public String getPrefix() {
        return null == this.prefix ? "OX" : this.prefix;
    }

    public boolean isPrefix(String expected) {
        return (null == this.prefix ? "OX" : this.prefix).equals(expected);
    }

    public OXException setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public boolean isInterceptable() {
        return this.interceptable;
    }

    public OXException setInterceptable(boolean interceptable) {
        this.interceptable = interceptable;
        return this;
    }

    public OXExceptionCode getExceptionCode() {
        return this.exceptionCode;
    }

    public OXException setExceptionCode(OXExceptionCode exceptionCode) {
        this.exceptionCode = exceptionCode;
        return this;
    }

    public final String getErrorCode() {
        return this.getPrefix() + '-' + String.format("%04d", this.code);
    }

    public String getDisplayMessage(Locale locale) {
        String msg = this.getDisplayMessage0(locale);
        return msg == null ? "[Not available]" : msg;
    }

    private String getDisplayMessage0(Locale locale) {
        Locale lcl = null == locale ? Locale.US : locale;
        String msg = I18n.getInstance().translate(lcl, this.displayMessage);
        if (msg != null && this.displayArgs != null) {
            try {
                msg = String.format(lcl, msg, this.displayArgs);
            }
            catch (NullPointerException e) {
                msg = null;
            }
            catch (MissingFormatArgumentException e) {
                LOG.debug("Missing format argument: >>{}<<", (Object)msg, (Object)e);
            }
            catch (IllegalFormatException e) {
                LOG.error("Illegal message format: >>{}<<", (Object)msg, (Object)e);
            }
        }
        return OXException.dropSubsequentWhitespaces(msg);
    }

    public final boolean similarTo(OXExceptionCode exceptionCode) {
        return exceptionCode.getCategory() == this.getCategory() && exceptionCode.getNumber() == this.getCode();
    }

    public final boolean similarTo(OXException other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return other.getCategory() == this.getCategory() && other.getCode() == this.getCode();
    }

    @Override
    public String getMessage() {
        return this.getLogMessage();
    }

    @Override
    public String toString() {
        return this.getLogMessage();
    }

    @Deprecated
    public void addTruncatedId(final int truncatedId) {
        this.problematics.add(new Truncated(){

            @Override
            public int getId() {
                return truncatedId;
            }

            @Override
            public int getLength() {
                return -1;
            }

            @Override
            public int getMaxSize() {
                return -1;
            }
        });
    }

    public void addProblematic(ProblematicAttribute problematic) {
        this.problematics.add(problematic);
    }

    public final ProblematicAttribute[] getProblematics() {
        return this.problematics.isEmpty() ? EMPTY_PROBLEMATICS : this.problematics.toArray(new ProblematicAttribute[this.problematics.size()]);
    }

    public boolean containsArgument(String name) {
        return this.arguments.containsKey(name);
    }

    public Object getArgument(String name) {
        return this.arguments.get(name);
    }

    public Object setArgument(String name, Object value) {
        if (null == value) {
            return this.arguments.remove(name);
        }
        return this.arguments.put(name, value);
    }

    public Object removeArgument(String name) {
        return this.arguments.remove(name);
    }

    public Set<String> getArgumentNames() {
        return Collections.unmodifiableSet(this.arguments.keySet());
    }

    public Map<String, Object> getArguments() {
        return Collections.unmodifiableMap(this.arguments);
    }

    public boolean containsProperty(String name) {
        return this.properties.containsKey(name);
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public String setProperty(String name, String value) {
        if (null == value) {
            return this.properties.remove(name);
        }
        return this.properties.put(name, value);
    }

    public OXException setSessionProperties(Session session) {
        this.properties.put("com.openexchange.exception.sessionId", session.getSessionID());
        this.properties.put("com.openexchange.exception.client", session.getClient());
        this.properties.put("com.openexchange.exception.authId", session.getAuthId());
        this.properties.put("com.openexchange.exception.login", session.getLogin());
        this.properties.put("com.openexchange.exception.context", String.valueOf(session.getContextId()));
        this.properties.put("com.openexchange.exception.user", String.valueOf(session.getContextId()));
        return this;
    }

    public String removeProperty(String name) {
        return this.properties.remove(name);
    }

    public Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    private static String dropSubsequentWhitespaces(String message) {
        if (null == message) {
            return message;
        }
        return P.matcher(message).replaceAll("$1 $2");
    }

    public static interface Parsing
    extends ProblematicAttribute {
        public String getAttribute();
    }

    public static interface Truncated
    extends ProblematicAttribute {
        public int getId();

        public int getMaxSize();

        public int getLength();
    }

    public static interface ProblematicAttribute {
    }

    private static final class ComparableCategory
    implements Comparable<ComparableCategory> {
        protected final Category category;

        protected ComparableCategory(Category category) {
            this.category = category;
        }

        @Override
        public int compareTo(ComparableCategory other) {
            return this.category.compareTo(other.category);
        }
    }

    public static enum Generic {
        NONE,
        NOT_FOUND,
        NO_PERMISSION,
        MANDATORY_FIELD,
        CONFLICT;

    }
}

