/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.sessiond;

import com.openexchange.authentication.SessionEnhancement;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.java.util.UUIDs;
import com.openexchange.session.Session;
import com.openexchange.session.SimSession;
import com.openexchange.sessiond.AddSessionParameter;
import com.openexchange.sessiond.SessionExceptionCodes;
import com.openexchange.sessiond.SessionFilter;
import com.openexchange.sessiond.SessionMatcher;
import com.openexchange.sessiond.SessiondService;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SimSessiondService
implements SessiondService {
    private final ConcurrentMap<String, SimSession> sessionsById = new ConcurrentHashMap<String, SimSession>();

    public Session addSession(AddSessionParameter param) throws OXException {
        SimSession session = new SimSession(param.getUserId(), param.getContext().getContextId());
        session.setClient(param.getClient());
        session.setHash(param.getHash());
        session.setLoginName(param.getFullLogin());
        session.setPassword(param.getPassword());
        session.setLocalIp(param.getClientIP());
        session.setSecret(UUIDs.getUnformattedString((UUID)UUID.randomUUID()));
        Session existing = null;
        do {
            session.setSessionID(UUIDs.getUnformattedString((UUID)UUID.randomUUID()));
        } while ((existing = (Session)this.sessionsById.putIfAbsent(session.getSessionID(), session)) != null);
        SessionEnhancement enhancement = param.getEnhancement();
        if (null != enhancement) {
            enhancement.enhanceSession((Session)session);
        }
        return session;
    }

    public void changeSessionPassword(String sessionId, String newPassword) throws OXException {
        SimSession session = (SimSession)this.sessionsById.get(sessionId);
        if (session == null) {
            throw SessionExceptionCodes.PASSWORD_UPDATE_FAILED.create();
        }
        session.setPassword(newPassword);
    }

    public boolean removeSession(String sessionId) {
        return this.sessionsById.remove(sessionId) != null;
    }

    public int removeUserSessions(int userId, Context ctx) {
        return this.removeUserSessions(userId, ctx.getContextId());
    }

    public void removeContextSessions(int contextId) {
        SessionFilter filter = SessionFilter.create((String)("(contextId=" + contextId + ")"));
        this.filterSessionIds(filter, true);
    }

    public void removeUserSessionsGlobally(int userId, int contextId) throws OXException {
        this.removeUserSessions(userId, contextId);
    }

    public Collection<String> removeSessionsGlobally(SessionFilter filter) throws OXException {
        return this.filterSessionIds(filter, true);
    }

    private int removeUserSessions(int userId, int contextId) {
        SessionFilter filter = SessionFilter.create((String)("(&(userId=" + userId + ")(" + "contextId" + "=" + contextId + "))"));
        List<String> removed = this.filterSessionIds(filter, true);
        return removed.size();
    }

    private List<String> filterSessionIds(SessionFilter filter, boolean remove) {
        LinkedList<String> sessions = new LinkedList<String>();
        Iterator iterator = this.sessionsById.values().iterator();
        while (iterator.hasNext()) {
            SimSession session = (SimSession)iterator.next();
            if (!filter.apply((Session)session)) continue;
            if (remove) {
                iterator.remove();
            }
            sessions.add(session.getSessionID());
        }
        return sessions;
    }

    private List<Session> filterSessions(SessionFilter filter, boolean remove) {
        LinkedList<Session> sessions = new LinkedList<Session>();
        Iterator iterator = this.sessionsById.values().iterator();
        while (iterator.hasNext()) {
            SimSession session = (SimSession)iterator.next();
            if (!filter.apply((Session)session)) continue;
            if (remove) {
                iterator.remove();
            }
            sessions.add(session);
        }
        return sessions;
    }

    public int getUserSessions(int userId, int contextId) {
        SessionFilter filter = SessionFilter.create((String)("(&(userId=" + userId + ")(" + "contextId" + "=" + contextId + "))"));
        List<String> sessionIds = this.filterSessionIds(filter, false);
        return sessionIds.size();
    }

    public Collection<Session> getSessions(int userId, int contextId) {
        SessionFilter filter = SessionFilter.create((String)("(&(userId=" + userId + ")(" + "contextId" + "=" + contextId + "))"));
        return this.filterSessions(filter, false);
    }

    public Session findFirstMatchingSessionForUser(int userId, int contextId, SessionMatcher matcher) {
        SessionFilter filter = SessionFilter.create((String)("(&(userId=" + userId + ")(" + "contextId" + "=" + contextId + "))"));
        List<Session> userSessions = this.filterSessions(filter, false);
        for (Session session : userSessions) {
            if (!matcher.accepts(session)) continue;
            return session;
        }
        return null;
    }

    public Session getSession(String sessionId) {
        return (Session)this.sessionsById.get(sessionId);
    }

    public Session getSessionByAlternativeId(String altId) {
        SessionFilter filter = SessionFilter.create((String)("(" + Session.PARAM_ALTERNATIVE_ID + "=" + altId + ")"));
        List<Session> sessions = this.filterSessions(filter, false);
        if (sessions.isEmpty()) {
            return null;
        }
        return sessions.get(0);
    }

    public Session getSessionByRandomToken(String randomToken, String localIp) {
        return null;
    }

    public Session getSessionByRandomToken(String randomToken) {
        return null;
    }

    public Session getSessionWithTokens(String clientToken, String serverToken) throws OXException {
        return null;
    }

    public Collection<String> findSessionsGlobally(SessionFilter filter) throws OXException {
        return this.filterSessionIds(filter, false);
    }

    public int getNumberOfActiveSessions() {
        return this.sessionsById.size();
    }

    public Session getAnyActiveSessionForUser(int userId, int contextId) {
        SessionFilter filter = SessionFilter.create((String)("(&(userId=" + userId + ")(" + "contextId" + "=" + contextId + "))"));
        List<Session> sessions = this.filterSessions(filter, false);
        if (sessions.isEmpty()) {
            return null;
        }
        return sessions.get(0);
    }

    public void setLocalIp(String sessionId, String localIp) throws OXException {
        SimSession session = (SimSession)this.sessionsById.get(sessionId);
        if (session != null) {
            session.setLocalIp(localIp);
        }
    }

    public void setClient(String sessionId, String client) throws OXException {
        SimSession session = (SimSession)this.sessionsById.get(sessionId);
        if (session != null) {
            session.setClient(client);
        }
    }

    public void setHash(String sessionId, String hash) throws OXException {
        SimSession session = (SimSession)this.sessionsById.get(sessionId);
        if (session != null) {
            session.setHash(hash);
        }
    }

    public Collection<String> findSessions(SessionFilter filter) throws OXException {
        return this.filterSessionIds(filter, false);
    }
}

