/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.global.tools.iterator;

import com.openexchange.exception.OXException;
import com.openexchange.tools.iterator.ArrayIterator;
import com.openexchange.tools.iterator.MergingSearchIterator;
import com.openexchange.tools.iterator.SearchIterator;
import java.util.Comparator;
import junit.framework.TestCase;

public class MergingSearchIteratorTest
extends TestCase {
    public void testMerge() throws OXException {
        Object[] a = new Integer[]{0, 3, 4, 7, 9, 12, 13, 16};
        Object[] b = new Integer[]{1, 2, 5, 10, 18};
        Object[] c = new Integer[]{1, 6, 8, 11, 14, 20};
        Integer[] expected = new Integer[]{0, 1, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 18, 20};
        MergingSearchIterator complete = new MergingSearchIterator((Comparator)new IntegerComparator(), new SearchIterator[]{new ArrayIterator(a), new ArrayIterator(b), new ArrayIterator(c)});
        for (int i = 0; i < complete.size(); ++i) {
            MergingSearchIteratorTest.assertTrue((boolean)complete.hasNext());
            MergingSearchIteratorTest.assertEquals((Object)expected[i], (Object)complete.next());
        }
        MergingSearchIteratorTest.assertFalse((boolean)complete.hasNext());
    }

    public void testMergeEmptyWithFull() throws OXException {
        Object[] b;
        Object[] a = new Integer[]{};
        Object[] expected = b = new Integer[]{1, 2, 5, 10, 18};
        MergingSearchIterator complete = new MergingSearchIterator((Comparator)new IntegerComparator(), new SearchIterator[]{new ArrayIterator(a), new ArrayIterator(b)});
        for (int i = 0; i < complete.size(); ++i) {
            MergingSearchIteratorTest.assertTrue((boolean)complete.hasNext());
            MergingSearchIteratorTest.assertEquals((Object)expected[i], (Object)complete.next());
        }
        MergingSearchIteratorTest.assertFalse((boolean)complete.hasNext());
    }

    private static final class IntegerComparator
    implements Comparator<Integer> {
        private IntegerComparator() {
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            return o2 - o1;
        }
    }
}

