/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.infostore.folder;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStoragePermission;
import com.openexchange.file.storage.infostore.Services;
import com.openexchange.file.storage.infostore.folder.ParsedFolder;
import com.openexchange.file.storage.infostore.folder.ParsedPermission;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.ContentTypeDiscoveryService;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.Permission;
import com.openexchange.java.Strings;
import java.util.List;

public final class FolderParser {
    private static final String REAL_TREE_ID = FolderStorage.REAL_TREE_ID;
    private static final String INFOSTORE = "infostore";
    private static volatile ContentType contentType;

    private FolderParser() {
    }

    public static Folder parseFolder(FileStorageFolder fsFolder) throws OXException {
        if (null == fsFolder) {
            return null;
        }
        try {
            ParsedFolder folder = new ParsedFolder();
            folder.setTreeID(REAL_TREE_ID);
            String str = fsFolder.getId();
            if (!FolderParser.isEmpty(str)) {
                folder.setID(str);
            }
            if (!FolderParser.isEmpty(str = fsFolder.getParentId())) {
                folder.setParentID(str);
            }
            if (!FolderParser.isEmpty(str = fsFolder.getName())) {
                folder.setName(str);
            }
            folder.setContentType(FolderParser.getContentType());
            folder.setSubscribed(fsFolder.isSubscribed());
            List permissions = fsFolder.getPermissions();
            if (null != permissions && !permissions.isEmpty()) {
                folder.setPermissions(FolderParser.parsePermission(permissions));
            }
            folder.setMeta(fsFolder.getMeta());
            return folder;
        }
        catch (RuntimeException e) {
            throw FileStorageExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContentType getContentType() throws OXException {
        ContentType ct = contentType;
        if (null != ct) return ct;
        Class<FolderParser> clazz = FolderParser.class;
        synchronized (FolderParser.class) {
            ct = contentType;
            if (null != ct) return ct;
            ContentTypeDiscoveryService discoveryService = Services.getService(ContentTypeDiscoveryService.class);
            ct = discoveryService.getByString(INFOSTORE);
            if (null == ct) {
                throw FolderExceptionErrorMessage.UNKNOWN_CONTENT_TYPE.create(new Object[]{INFOSTORE});
            }
            contentType = ct;
            return ct;
        }
    }

    public static Permission[] parsePermission(List<FileStoragePermission> permissionsList) throws OXException {
        try {
            int numberOfPermissions = permissionsList.size();
            Permission[] perms = new Permission[numberOfPermissions];
            for (int i = 0; i < numberOfPermissions; ++i) {
                FileStoragePermission elem = permissionsList.get(i);
                int entity = elem.getEntity();
                ParsedPermission oclPerm = new ParsedPermission();
                oclPerm.setEntity(entity);
                oclPerm.setGroup(elem.isGroup());
                oclPerm.setAdmin(elem.isAdmin());
                oclPerm.setAllPermissions(elem.getFolderPermission(), elem.getReadPermission(), elem.getWritePermission(), elem.getDeletePermission());
                perms[i] = oclPerm;
            }
            return perms;
        }
        catch (RuntimeException e) {
            throw FileStorageExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Strings.isWhitespace((char)string.charAt(i));
        }
        return isWhitespace;
    }
}

