/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.infostore;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageAccountAccess;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStorageFolderAccess;
import com.openexchange.file.storage.FileStorageRandomFileAccess;
import com.openexchange.file.storage.FileStorageSequenceNumberProvider;
import com.openexchange.file.storage.FileStorageUtility;
import com.openexchange.file.storage.infostore.FieldMapping;
import com.openexchange.file.storage.infostore.FileMetadata;
import com.openexchange.file.storage.infostore.InfostoreDeltaWrapper;
import com.openexchange.file.storage.infostore.InfostoreFile;
import com.openexchange.file.storage.infostore.InfostoreSearchIterator;
import com.openexchange.file.storage.infostore.InfostoreTimedResult;
import com.openexchange.file.storage.infostore.ToInfostoreTermVisitor;
import com.openexchange.file.storage.infostore.internal.VirtualFolderInfostoreFacade;
import com.openexchange.file.storage.search.SearchTerm;
import com.openexchange.file.storage.search.SearchTermVisitor;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreFacade;
import com.openexchange.groupware.infostore.InfostoreSearchEngine;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.results.Delta;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.session.ServerSession;
import gnu.trove.list.array.TIntArrayList;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InfostoreAdapterFileAccess
implements FileStorageRandomFileAccess,
FileStorageSequenceNumberProvider {
    private static final InfostoreFacade VIRTUAL_INFOSTORE = new VirtualFolderInfostoreFacade();
    private static final Set<Long> VIRTUAL_FOLDERS;
    private final InfostoreFacade infostore;
    private final InfostoreSearchEngine search;
    private final Context ctx;
    private final User user;
    private final UserPermissionBits userPermissions;
    private final ServerSession sessionObj;
    private final FileStorageAccountAccess accountAccess;
    private final int hash;

    public InfostoreAdapterFileAccess(ServerSession session, InfostoreFacade infostore, InfostoreSearchEngine search, FileStorageAccountAccess accountAccess) {
        this.sessionObj = session;
        this.ctx = this.sessionObj.getContext();
        this.user = this.sessionObj.getUser();
        this.userPermissions = this.sessionObj.getUserPermissionBits();
        this.infostore = infostore;
        this.search = search;
        this.accountAccess = accountAccess;
        int prime = 31;
        int result = 1;
        result = 31 * result + (accountAccess == null ? 0 : accountAccess.getAccountId().hashCode());
        result = 31 * result + (this.ctx == null ? 0 : this.ctx.getContextId());
        this.hash = result = 31 * result + (this.user == null ? 0 : this.user.getId());
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InfostoreAdapterFileAccess)) {
            return false;
        }
        InfostoreAdapterFileAccess other = (InfostoreAdapterFileAccess)obj;
        if (this.accountAccess == null ? other.accountAccess != null : !this.accountAccess.getAccountId().equals(other.accountAccess.getAccountId())) {
            return false;
        }
        if (this.ctx == null ? other.ctx != null : this.ctx.getContextId() != other.ctx.getContextId()) {
            return false;
        }
        return !(this.user == null ? other.user != null : this.user.getId() != other.user.getId());
    }

    public boolean exists(String folderId, String id, String version) throws OXException {
        try {
            return this.getInfostore(folderId).exists(InfostoreAdapterFileAccess.ID(id), null == version ? -1 : Integer.parseInt(version), this.sessionObj);
        }
        catch (NumberFormatException e) {
            throw FileStorageExceptionCodes.FILE_NOT_FOUND.create((Throwable)e, new Object[]{id, folderId});
        }
    }

    public InputStream getDocument(String folderId, String id, String version) throws OXException {
        try {
            return this.getInfostore(folderId).getDocument(InfostoreAdapterFileAccess.ID(id), null == version ? -1 : Integer.parseInt(version), this.sessionObj);
        }
        catch (NumberFormatException e) {
            throw FileStorageExceptionCodes.FILE_NOT_FOUND.create((Throwable)e, new Object[]{id, folderId});
        }
    }

    public InputStream getDocument(String folderId, String id, String version, long offset, long length) throws OXException {
        try {
            return this.getInfostore(folderId).getDocument(InfostoreAdapterFileAccess.ID(id), null == version ? -1 : Integer.parseInt(version), offset, length, this.sessionObj);
        }
        catch (NumberFormatException e) {
            throw FileStorageExceptionCodes.FILE_NOT_FOUND.create((Throwable)e, new Object[]{id, folderId});
        }
    }

    public File getFileMetadata(String folderId, String id, String version) throws OXException {
        try {
            DocumentMetadata documentMetadata = this.getInfostore(folderId).getDocumentMetadata(InfostoreAdapterFileAccess.ID(id), null == version ? -1 : Integer.parseInt(version), this.sessionObj);
            if (null != folderId && documentMetadata.getFolderId() > 0L && !folderId.equals(Long.toString(documentMetadata.getFolderId()))) {
                throw FileStorageExceptionCodes.FILE_NOT_FOUND.create(new Object[]{id, folderId});
            }
            return new InfostoreFile(documentMetadata);
        }
        catch (NumberFormatException e) {
            throw FileStorageExceptionCodes.FILE_NOT_FOUND.create((Throwable)e, new Object[]{id, folderId});
        }
    }

    public void lock(String folderId, String id, long diff) throws OXException {
        try {
            this.getInfostore(folderId).lock(InfostoreAdapterFileAccess.ID(id), diff, this.sessionObj);
        }
        catch (NumberFormatException e) {
            throw FileStorageExceptionCodes.FILE_NOT_FOUND.create((Throwable)e, new Object[]{id, folderId});
        }
    }

    public void removeDocument(String folderId, long sequenceNumber) throws OXException {
        this.getInfostore(folderId).removeDocument(InfostoreAdapterFileAccess.FOLDERID(folderId), sequenceNumber, this.sessionObj);
    }

    public List<FileStorageFileAccess.IDTuple> removeDocument(List<FileStorageFileAccess.IDTuple> ids, long sequenceNumber) throws OXException {
        return this.removeDocument(ids, sequenceNumber, false);
    }

    public List<FileStorageFileAccess.IDTuple> removeDocument(List<FileStorageFileAccess.IDTuple> ids, long sequenceNumber, boolean hardDelete) throws OXException {
        int[] infostoreIDs = new int[ids.size()];
        HashMap<Integer, FileStorageFileAccess.IDTuple> id2folder = new HashMap<Integer, FileStorageFileAccess.IDTuple>(ids.size());
        for (int i = 0; i < infostoreIDs.length; ++i) {
            FileStorageFileAccess.IDTuple tuple = ids.get(i);
            infostoreIDs[i] = InfostoreAdapterFileAccess.ID(tuple.getId());
            id2folder.put(infostoreIDs[i], tuple);
        }
        InfostoreFacade infostore = this.getInfostore(null);
        int[] conflicted = null;
        if (hardDelete) {
            conflicted = infostore.removeDocument(infostoreIDs, sequenceNumber, this.sessionObj);
        } else {
            String trashFolderID = this.getTrashFolderID();
            if (null == trashFolderID) {
                conflicted = infostore.removeDocument(infostoreIDs, sequenceNumber, this.sessionObj);
            } else {
                FileStorageFolderAccess folderAccess = this.getAccountAccess().getFolderAccess();
                String rootFolderID = folderAccess.getRootFolder().getId();
                ArrayList<Integer> filesToDelete = new ArrayList<Integer>();
                ArrayList<Integer> filesToMove = new ArrayList<Integer>();
                HashMap<String, FileStorageFolder> knownFolders = new HashMap<String, FileStorageFolder>();
                for (FileStorageFileAccess.IDTuple tuple : ids) {
                    String folderID = tuple.getFolder();
                    while (null != folderID && !trashFolderID.equals(folderID) && !rootFolderID.equals(folderID)) {
                        FileStorageFolder folder = (FileStorageFolder)knownFolders.get(folderID);
                        if (null == folder) {
                            folder = folderAccess.getFolder(folderID);
                            knownFolders.put(folderID, folder);
                        }
                        folderID = folder.getParentId();
                    }
                    if (trashFolderID.equals(folderID)) {
                        filesToDelete.add(Integer.valueOf(tuple.getId()));
                        continue;
                    }
                    filesToMove.add(Integer.valueOf(tuple.getId()));
                }
                if (0 < filesToDelete.size()) {
                    int[] idsToDelete = new int[filesToDelete.size()];
                    for (int i = 0; i < idsToDelete.length; ++i) {
                        idsToDelete[i] = (Integer)filesToDelete.get(i);
                    }
                    conflicted = infostore.removeDocument(idsToDelete, sequenceNumber, this.sessionObj);
                }
                if (0 < filesToMove.size()) {
                    int[] idsToMove = new int[filesToMove.size()];
                    for (int i = 0; i < idsToMove.length; ++i) {
                        idsToMove[i] = (Integer)filesToMove.get(i);
                    }
                    int[] conflicted2 = infostore.moveDocuments(this.sessionObj, idsToMove, sequenceNumber, trashFolderID, true);
                    if (null == conflicted || 0 == conflicted.length) {
                        conflicted = conflicted2;
                    } else if (null != conflicted2 && 0 < conflicted2.length) {
                        int[] temp = new int[conflicted.length + conflicted2.length];
                        System.arraycopy(conflicted, 0, temp, 0, conflicted.length);
                        System.arraycopy(conflicted2, 0, temp, conflicted.length, conflicted2.length);
                        conflicted = temp;
                    }
                }
            }
        }
        ArrayList<FileStorageFileAccess.IDTuple> retval = new ArrayList<FileStorageFileAccess.IDTuple>(conflicted.length);
        for (int id : conflicted) {
            retval.add((FileStorageFileAccess.IDTuple)id2folder.get(id));
        }
        return retval;
    }

    public String[] removeVersion(String folderId, String id, String[] versions) throws OXException {
        return InfostoreAdapterFileAccess.toStrings(this.getInfostore(folderId).removeVersion(InfostoreAdapterFileAccess.ID(id), InfostoreAdapterFileAccess.parseInts(versions), this.sessionObj));
    }

    private static int[] parseInts(String[] sa) {
        if (null == sa) {
            return null;
        }
        int[] ret = new int[sa.length];
        for (int i = 0; i < sa.length; ++i) {
            String version = sa[i];
            ret[i] = null == version ? -1 : Integer.parseInt(version);
        }
        return ret;
    }

    private static String[] toStrings(int[] ia) {
        if (null == ia) {
            return null;
        }
        String[] ret = new String[ia.length];
        for (int i = 0; i < ia.length; ++i) {
            int iVersion = ia[i];
            ret[i] = iVersion < 0 ? null : Integer.toString(iVersion);
        }
        return ret;
    }

    public void saveDocument(File file, InputStream data, long sequenceNumber) throws OXException {
        FileStorageUtility.checkUrl((File)file);
        this.getInfostore(file.getFolderId()).saveDocument((DocumentMetadata)new FileMetadata(file), data, sequenceNumber, this.sessionObj);
    }

    public void saveDocument(File file, InputStream data, long sequenceNumber, List<File.Field> modifiedFields) throws OXException {
        if (modifiedFields.contains(File.Field.URL)) {
            FileStorageUtility.checkUrl((File)file);
        }
        this.getInfostore(file.getFolderId()).saveDocument((DocumentMetadata)new FileMetadata(file), data, sequenceNumber, FieldMapping.getMatching(modifiedFields), this.sessionObj);
    }

    public void saveDocument(File file, InputStream data, long sequenceNumber, List<File.Field> modifiedFields, boolean ignoreVersion) throws OXException {
        if (modifiedFields.contains(File.Field.URL)) {
            FileStorageUtility.checkUrl((File)file);
        }
        this.getInfostore(file.getFolderId()).saveDocument((DocumentMetadata)new FileMetadata(file), data, sequenceNumber, FieldMapping.getMatching(modifiedFields), ignoreVersion, this.sessionObj);
    }

    public void saveDocument(File file, InputStream data, long sequenceNumber, List<File.Field> modifiedFields, long offset) throws OXException {
        if (modifiedFields.contains(File.Field.URL)) {
            FileStorageUtility.checkUrl((File)file);
        }
        this.getInfostore(file.getFolderId()).saveDocument((DocumentMetadata)new FileMetadata(file), data, sequenceNumber, FieldMapping.getMatching(modifiedFields), offset, this.sessionObj);
    }

    public void saveFileMetadata(File file, long sequenceNumber) throws OXException {
        FileStorageUtility.checkUrl((File)file);
        this.getInfostore(file.getFolderId()).saveDocumentMetadata((DocumentMetadata)new FileMetadata(file), sequenceNumber, this.sessionObj);
    }

    public void saveFileMetadata(File file, long sequenceNumber, List<File.Field> modifiedFields) throws OXException {
        if (modifiedFields.contains(File.Field.URL)) {
            FileStorageUtility.checkUrl((File)file);
        }
        this.getInfostore(file.getFolderId()).saveDocumentMetadata((DocumentMetadata)new FileMetadata(file), sequenceNumber, FieldMapping.getMatching(modifiedFields), this.sessionObj);
    }

    public void touch(String folderId, String id) throws OXException {
        this.getInfostore(folderId).touch(InfostoreAdapterFileAccess.ID(id), this.sessionObj);
    }

    public void unlock(String folderId, String id) throws OXException {
        this.getInfostore(folderId).unlock(InfostoreAdapterFileAccess.ID(id), this.sessionObj);
    }

    public Delta<File> getDelta(String folderId, long updateSince, List<File.Field> fields, boolean ignoreDeleted) throws OXException {
        Delta delta = this.getInfostore(folderId).getDelta(InfostoreAdapterFileAccess.FOLDERID(folderId), updateSince, FieldMapping.getMatching(fields), ignoreDeleted, this.sessionObj);
        return new InfostoreDeltaWrapper((Delta<DocumentMetadata>)delta);
    }

    public Delta<File> getDelta(String folderId, long updateSince, List<File.Field> fields, File.Field sort, FileStorageFileAccess.SortDirection order, boolean ignoreDeleted) throws OXException {
        Delta delta = this.getInfostore(folderId).getDelta(InfostoreAdapterFileAccess.FOLDERID(folderId), updateSince, FieldMapping.getMatching(fields), FieldMapping.getMatching(sort), FieldMapping.getSortDirection(order), ignoreDeleted, this.sessionObj);
        return new InfostoreDeltaWrapper((Delta<DocumentMetadata>)delta);
    }

    public Map<String, Long> getSequenceNumbers(List<String> folderIds) throws OXException {
        HashMap<String, Long> sequenceNumbers = new HashMap<String, Long>(folderIds.size());
        ArrayList<Long> foldersToQuery = new ArrayList<Long>(folderIds.size());
        for (String folderId : folderIds) {
            Long id = Long.valueOf(folderId);
            if (VIRTUAL_FOLDERS.contains(id)) {
                sequenceNumbers.put(folderId, 0L);
                continue;
            }
            foldersToQuery.add(id);
        }
        if (0 < foldersToQuery.size()) {
            Map infostoreNumbers = this.infostore.getSequenceNumbers(foldersToQuery, true, this.sessionObj);
            for (Map.Entry entry : infostoreNumbers.entrySet()) {
                sequenceNumbers.put(String.valueOf((Long)entry.getKey()), (Long)entry.getValue());
            }
        }
        return sequenceNumbers;
    }

    public TimedResult<File> getDocuments(String folderId) throws OXException {
        TimedResult documents = this.getInfostore(folderId).getDocuments(InfostoreAdapterFileAccess.FOLDERID(folderId), this.sessionObj);
        return new InfostoreTimedResult((TimedResult<DocumentMetadata>)documents);
    }

    public TimedResult<File> getDocuments(String folderId, List<File.Field> fields) throws OXException {
        TimedResult documents = this.getInfostore(folderId).getDocuments(InfostoreAdapterFileAccess.FOLDERID(folderId), FieldMapping.getMatching(fields), this.sessionObj);
        return new InfostoreTimedResult((TimedResult<DocumentMetadata>)documents);
    }

    public TimedResult<File> getDocuments(String folderId, List<File.Field> fields, File.Field sort, FileStorageFileAccess.SortDirection order) throws OXException {
        TimedResult documents = this.getInfostore(folderId).getDocuments(InfostoreAdapterFileAccess.FOLDERID(folderId), FieldMapping.getMatching(fields), FieldMapping.getMatching(sort), FieldMapping.getSortDirection(order), this.sessionObj);
        return new InfostoreTimedResult((TimedResult<DocumentMetadata>)documents);
    }

    public TimedResult<File> getDocuments(List<FileStorageFileAccess.IDTuple> ids, List<File.Field> fields) throws OXException {
        int[] infostoreIDs = InfostoreAdapterFileAccess.IDS(ids);
        try {
            TimedResult documents = this.getInfostore(null).getDocuments(infostoreIDs, FieldMapping.getMatching(fields), this.sessionObj);
            return new InfostoreTimedResult((TimedResult<DocumentMetadata>)documents);
        }
        catch (IllegalAccessException e) {
            throw new OXException((Throwable)e);
        }
    }

    public TimedResult<File> getVersions(String folderId, String id) throws OXException {
        TimedResult versions = this.getInfostore(folderId).getVersions(InfostoreAdapterFileAccess.ID(id), this.sessionObj);
        return new InfostoreTimedResult((TimedResult<DocumentMetadata>)versions);
    }

    public TimedResult<File> getVersions(String folderId, String id, List<File.Field> fields) throws OXException {
        TimedResult versions = this.getInfostore(folderId).getVersions(InfostoreAdapterFileAccess.ID(id), FieldMapping.getMatching(fields), this.sessionObj);
        return new InfostoreTimedResult((TimedResult<DocumentMetadata>)versions);
    }

    public TimedResult<File> getVersions(String folderId, String id, List<File.Field> fields, File.Field sort, FileStorageFileAccess.SortDirection order) throws OXException {
        TimedResult versions = this.getInfostore(folderId).getVersions(InfostoreAdapterFileAccess.ID(id), FieldMapping.getMatching(fields), FieldMapping.getMatching(sort), FieldMapping.getSortDirection(order), this.sessionObj);
        return new InfostoreTimedResult((TimedResult<DocumentMetadata>)versions);
    }

    public SearchIterator<File> search(String pattern, List<File.Field> fields, String folderId, File.Field sort, FileStorageFileAccess.SortDirection order, int start, int end) throws OXException {
        int folder = folderId == null ? -10 : Integer.parseInt(folderId);
        SearchIterator iterator = this.search.search(pattern, FieldMapping.getMatching(fields), folder, FieldMapping.getMatching(sort), FieldMapping.getSortDirection(order), start, end, this.ctx, this.user, this.userPermissions);
        return new InfostoreSearchIterator((SearchIterator<DocumentMetadata>)iterator);
    }

    public SearchIterator<File> search(List<String> folderIds, SearchTerm<?> searchTerm, List<File.Field> fields, File.Field sort, FileStorageFileAccess.SortDirection order, int start, int end) throws OXException {
        TIntArrayList fids = new TIntArrayList(null == folderIds ? 0 : folderIds.size());
        if (null != folderIds) {
            for (String folderId : folderIds) {
                try {
                    fids.add(Integer.parseInt(folderId));
                }
                catch (NumberFormatException e) {
                    throw FileStorageExceptionCodes.INVALID_FOLDER_IDENTIFIER.create(new Object[]{folderId});
                }
            }
        }
        ToInfostoreTermVisitor visitor = new ToInfostoreTermVisitor();
        searchTerm.visit((SearchTermVisitor)visitor);
        SearchIterator iterator = this.search.search(fids.toArray(), visitor.getInfostoreTerm(), FieldMapping.getMatching(fields), FieldMapping.getMatching(sort), FieldMapping.getSortDirection(order), start, end, this.ctx, this.user, this.userPermissions);
        return new InfostoreSearchIterator((SearchIterator<DocumentMetadata>)iterator);
    }

    public void commit() throws OXException {
        this.infostore.commit();
    }

    public void finish() throws OXException {
        this.infostore.finish();
    }

    public void rollback() throws OXException {
        this.infostore.rollback();
    }

    public void setCommitsTransaction(boolean commits) {
        this.infostore.setCommitsTransaction(commits);
    }

    public void setRequestTransactional(boolean transactional) {
        this.infostore.setRequestTransactional(transactional);
    }

    public void setTransactional(boolean transactional) {
        this.infostore.setTransactional(transactional);
    }

    public void startTransaction() throws OXException {
        this.infostore.startTransaction();
    }

    private static int ID(String id) {
        return Integer.parseInt(id);
    }

    private static long FOLDERID(String folderId) {
        return Long.parseLong(folderId);
    }

    private static int[] IDS(List<FileStorageFileAccess.IDTuple> ids) {
        int[] infostoreIDs = new int[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            infostoreIDs[i] = InfostoreAdapterFileAccess.ID(ids.get(i).getId());
        }
        return infostoreIDs;
    }

    public FileStorageAccountAccess getAccountAccess() {
        return this.accountAccess;
    }

    public FileStorageFileAccess.IDTuple copy(FileStorageFileAccess.IDTuple source, String version, String destFolder, File update, InputStream newFile, List<File.Field> modifiedFields) throws OXException {
        File orig = this.getFileMetadata(source.getFolder(), source.getId(), version);
        InputStream in = newFile;
        if (in == null && orig.getFileName() != null) {
            in = this.getDocument(source.getFolder(), source.getId(), version);
        }
        if (update != null) {
            orig.copyFrom(update, modifiedFields.toArray(new File.Field[modifiedFields.size()]));
            if (!modifiedFields.contains(File.Field.CREATED)) {
                orig.setCreated(null);
            }
        }
        orig.setId(NEW);
        orig.setFolderId(destFolder);
        if (in == null) {
            this.saveFileMetadata(orig, -1L);
        } else {
            this.saveDocument(orig, in, -1L);
        }
        return new FileStorageFileAccess.IDTuple(destFolder, orig.getId());
    }

    public FileStorageFileAccess.IDTuple move(FileStorageFileAccess.IDTuple source, String destFolder, long sequenceNumber, File update, List<File.Field> modifiedFields) throws OXException {
        update.setFolderId(destFolder);
        update.setId(source.getId());
        this.saveFileMetadata(update, sequenceNumber, modifiedFields);
        return new FileStorageFileAccess.IDTuple(update.getFolderId(), update.getId());
    }

    public InfostoreFacade getInfostore(String folderId) {
        if (folderId != null && VIRTUAL_FOLDERS.contains(Long.valueOf(folderId))) {
            return VIRTUAL_INFOSTORE;
        }
        return this.infostore;
    }

    private String getTrashFolderID() throws OXException {
        block3: {
            FileStorageFolderAccess folderAccess = this.getAccountAccess().getFolderAccess();
            try {
                FileStorageFolder trashFolder = folderAccess.getTrashFolder();
                if (null != trashFolder) {
                    return trashFolder.getId();
                }
            }
            catch (OXException e) {
                if (FileStorageExceptionCodes.NO_SUCH_FOLDER.equals(e)) break block3;
                throw e;
            }
        }
        return null;
    }

    static {
        HashSet<Long> set = new HashSet<Long>(4);
        set.add(14L);
        set.add(9L);
        set.add(15L);
        set.add(10L);
        VIRTUAL_FOLDERS = Collections.unmodifiableSet(set);
    }
}

