/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.webdav.action.ActionTestCase;
import com.openexchange.webdav.action.MockWebdavRequest;
import com.openexchange.webdav.action.MockWebdavResponse;
import com.openexchange.webdav.action.WebdavOptionsAction;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.WebdavResponse;
import com.openexchange.webdav.protocol.WebdavPath;
import java.util.Arrays;
import java.util.HashSet;

public class OptionsTest
extends ActionTestCase {
    public void testOptions() throws Exception {
        String[] got;
        WebdavPath INDEX_HTML_URL = this.testCollection.dup().append(new String[]{"index.html"});
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(INDEX_HTML_URL);
        WebdavOptionsAction action = new WebdavOptionsAction();
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        OptionsTest.assertEquals((String)"0", (String)res.getHeader("content-length"));
        HashSet<String> expected = new HashSet<String>(Arrays.asList("GET", "PUT", "DELETE", "HEAD", "OPTIONS", "TRACE", "PROPPATCH", "PROPFIND", "MOVE", "COPY", "LOCK", "UNLOCK", "REPORT", "ACL", "MKCALENDAR"));
        for (String allow : got = res.getHeader("Allow").split("\\s*,\\s*")) {
            OptionsTest.assertTrue((String)("Didn't expect: " + allow), (boolean)expected.remove(allow));
        }
        OptionsTest.assertTrue((String)((Object)expected).toString(), (boolean)expected.isEmpty());
        String[] davs = res.getHeader("DAV").split("\\s*,\\s*");
        OptionsTest.assertEquals((int)12, (int)davs.length);
        OptionsTest.assertEquals((String)"1", (String)davs[0]);
        OptionsTest.assertEquals((String)"2", (String)davs[1]);
        OptionsTest.assertEquals((String)"3", (String)davs[2]);
        OptionsTest.assertEquals((String)"access-control", (String)davs[3]);
        OptionsTest.assertEquals((String)"calendar-access", (String)davs[4]);
        OptionsTest.assertEquals((String)"addressbook", (String)davs[5]);
        OptionsTest.assertEquals((String)"extended-mkcol", (String)davs[6]);
        OptionsTest.assertEquals((String)"calendar-auto-schedule", (String)davs[7]);
        OptionsTest.assertEquals((String)"calendar-schedule", (String)davs[8]);
        OptionsTest.assertEquals((String)"calendarserver-sharing", (String)davs[9]);
        OptionsTest.assertEquals((String)"calendarserver-principal-search", (String)davs[10]);
        OptionsTest.assertEquals((String)"calendarserver-principal-property-search", (String)davs[11]);
        OptionsTest.assertEquals((String)"bytes", (String)res.getHeader("Accept-Ranges"));
    }
}

