/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.tools.versit.AbstractOXContainerConverterTest;

public class OXContainerConverterTest
extends AbstractOXContainerConverterTest {
    public void test7472_forPrivate() throws Exception {
        String versitData = "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//Apple Computer\\, Inc//iCal 2.0//EN\nBEGIN:VEVENT\nCLASS:PRIVATE\nDTSTART:20070514T150000Z\nDTEND:20070514T163000Z\nLOCATION:Olpe\nSUMMARY:Simple iCal Appointment\nDESCRIPTION:Notes here...\nEND:VEVENT\nEND:VCALENDAR\n";
        this.isFlaggedAsPrivate("BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//Apple Computer\\, Inc//iCal 2.0//EN\nBEGIN:VEVENT\nCLASS:PRIVATE\nDTSTART:20070514T150000Z\nDTEND:20070514T163000Z\nLOCATION:Olpe\nSUMMARY:Simple iCal Appointment\nDESCRIPTION:Notes here...\nEND:VEVENT\nEND:VCALENDAR\n");
    }

    public void test7472_forConfidential() {
        String versitData = "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//Apple Computer\\, Inc//iCal 2.0//EN\nBEGIN:VEVENT\nCLASS:CONFIDENTIAL\nDTSTART:20070514T150000Z\nDTEND:20070514T163000Z\nLOCATION:Olpe\nSUMMARY:Simple iCal Appointment\nDESCRIPTION:Notes here...\nEND:VEVENT\nEND:VCALENDAR\n";
        try {
            this.isFlaggedAsPrivate("BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//Apple Computer\\, Inc//iCal 2.0//EN\nBEGIN:VEVENT\nCLASS:CONFIDENTIAL\nDTSTART:20070514T150000Z\nDTEND:20070514T163000Z\nLOCATION:Olpe\nSUMMARY:Simple iCal Appointment\nDESCRIPTION:Notes here...\nEND:VEVENT\nEND:VCALENDAR\n");
            OXContainerConverterTest.fail((String)"Should throw privacy exception");
        }
        catch (OXException e) {
            OXContainerConverterTest.assertTrue((String)"Should throw privacy exception", (boolean)true);
            return;
        }
        catch (Exception e) {
            OXContainerConverterTest.fail((String)"Wanted ConverterPrivacyException");
        }
    }

    public void test7472_forPublic() throws Exception {
        String versitData = "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//Apple Computer\\, Inc//iCal 2.0//EN\nBEGIN:VEVENT\nCLASS:PUBLIC\nDTSTART:20070514T150000Z\nDTEND:20070514T163000Z\nLOCATION:Olpe\nSUMMARY:Simple iCal Appointment\nDESCRIPTION:Notes here...\nEND:VEVENT\nEND:VCALENDAR\n";
        OXContainerConverterTest.assertFalse((boolean)this.isFlaggedAsPrivate("BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//Apple Computer\\, Inc//iCal 2.0//EN\nBEGIN:VEVENT\nCLASS:PUBLIC\nDTSTART:20070514T150000Z\nDTEND:20070514T163000Z\nLOCATION:Olpe\nSUMMARY:Simple iCal Appointment\nDESCRIPTION:Notes here...\nEND:VEVENT\nEND:VCALENDAR\n"));
    }

    public void test8475() throws Exception {
        User testUser = OXContainerConverterTest.getUserParticipant();
        String participantEmail = testUser.getMail();
        String versitData = "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//Apple Computer\\, Inc//iCal 1.5//EN\nBEGIN:VTODO\nORGANIZER:MAILTO:tobias.friedrich@open-xchange.com\nATTENDEE:MAILTO:" + participantEmail + "\n" + "DTSTART:20070608T080000Z\n" + "STATUS:COMPLETED\n" + "SUMMARY:Test todo\n" + "UID:8D4FFA7A-ABC0-11D7-8200-00306571349C-RID\n" + "DUE:20070618T080000Z\n" + "END:VTODO\n" + "END:VCALENDAR";
        Task task = this.convertTask(versitData);
        Participant[] participants = task.getParticipants();
        OXContainerConverterTest.assertEquals((int)1, (int)participants.length);
        try {
            UserParticipant p = (UserParticipant)participants[0];
            OXContainerConverterTest.assertEquals((int)testUser.getId(), (int)p.getIdentifier());
        }
        catch (ClassCastException e) {
            OXContainerConverterTest.fail((String)("User with e-mail " + participantEmail + " should be internal user"));
        }
    }
}

