/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.fixtures.transformators;

import com.openexchange.exception.OXException;
import com.openexchange.test.fixtures.Document;
import com.openexchange.test.fixtures.FixtureLoader;
import com.openexchange.test.fixtures.transformators.Transformator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class FileToByteArrayTransformator
implements Transformator {
    private final FixtureLoader fixtureLoader;

    public FileToByteArrayTransformator(FixtureLoader fixtureLoader) {
        this.fixtureLoader = fixtureLoader;
    }

    public byte[] transform(String value) throws OXException {
        if (null == value || 1 > value.length()) {
            return null;
        }
        String fixtureName = "documents";
        String fixtureEntry = "";
        int idx = value.indexOf(58);
        if (0 < idx && value.length() > idx) {
            fixtureName = value.substring(0, idx);
            fixtureEntry = value.substring(idx + 1);
        } else {
            fixtureEntry = value;
        }
        try {
            return this.getByteArray(this.getDocument(fixtureName, fixtureEntry).getFile());
        }
        catch (IOException e) {
            throw new OXException((Throwable)e);
        }
    }

    private final Document getDocument(String fixtureName, String fixtureEntry) throws OXException {
        return this.fixtureLoader.getFixtures(fixtureName, Document.class).getEntry(fixtureEntry).getEntry();
    }

    private byte[] getByteArray(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] data = new byte[(int)file.length()];
        fileInputStream.read(data);
        fileInputStream.close();
        return data;
    }
}

