/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test;

import com.openexchange.test.TestInit;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

public class AjaxInit {
    private static boolean ajaxPropertiesLoaded = false;
    private static boolean isAjaxDirInitialized = false;
    private static String[] ajaxPropFiles;
    public static Properties ajaxProps;

    private static void loadAJAXProperties() {
        TestInit.loadTestProperties();
        ajaxProps = new Properties();
        try {
            ajaxProps.load(new FileInputStream(AjaxInit.getFileName()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ajaxPropertiesLoaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getFileName() {
        String retval = null;
        if (TestInit.getTestProperties().getProperty("ajaxPropertiesDir") == null) return TestInit.getTestProperties().getProperty("ajaxPropertiesFile");
        if (isAjaxDirInitialized) return ajaxPropFiles[(int)(Math.random() * (double)ajaxPropFiles.length)];
        Class<AjaxInit> clazz = AjaxInit.class;
        synchronized (AjaxInit.class) {
            if (isAjaxDirInitialized) return ajaxPropFiles[(int)(Math.random() * (double)ajaxPropFiles.length)];
            AjaxInit.initAjaxProperties();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ajaxPropFiles[(int)(Math.random() * (double)ajaxPropFiles.length)];
        }
    }

    private static void initAjaxProperties() {
        File dir;
        String ajaxPropertiesDir = TestInit.getTestProperties().getProperty("ajaxPropertiesDir");
        if (!ajaxPropertiesDir.endsWith(System.getProperty("file.separator"))) {
            ajaxPropertiesDir = ajaxPropertiesDir + System.getProperty("file.separator");
        }
        if ((dir = new File(ajaxPropertiesDir)).isDirectory()) {
            ArrayList<String> fileList = new ArrayList<String>();
            for (String fileName : dir.list()) {
                File myFile = new File(ajaxPropertiesDir + fileName);
                if (myFile.isDirectory() || !myFile.canRead() || myFile.getName().length() != 0 && myFile.getName().charAt(0) == '.') continue;
                fileList.add(myFile.getAbsolutePath());
            }
            ajaxPropFiles = new String[fileList.size()];
            System.arraycopy(fileList.toArray(), 0, ajaxPropFiles, 0, fileList.size());
        }
        isAjaxDirInitialized = true;
    }

    public static Properties getAJAXProperties() {
        if (!ajaxPropertiesLoaded || TestInit.getTestProperties().getProperty("ajaxPropertiesDir") != null) {
            AjaxInit.loadAJAXProperties();
        }
        return ajaxProps;
    }

    public static String getAJAXProperty(String key) {
        return AjaxInit.getAJAXProperties().getProperty(key);
    }

    static {
        ajaxProps = null;
    }
}

