/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.utilitytests;

import com.openexchange.java.CharsetDetector;
import com.openexchange.mail.AbstractMailTest;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import java.io.ByteArrayInputStream;

public final class MailCharsetDetectorTest
extends AbstractMailTest {
    public MailCharsetDetectorTest() {
    }

    public MailCharsetDetectorTest(String name) {
        super(name);
    }

    public void testCharsetDetection() {
        try {
            String charset = null;
            String usedCharset = null;
            usedCharset = "US-ASCII";
            charset = CharsetDetector.detectCharset((ByteArrayInputStream)new UnsynchronizedByteArrayInputStream("A text line".getBytes(usedCharset)));
            MailCharsetDetectorTest.assertTrue((String)(usedCharset + " not detected" + charset), (usedCharset.equalsIgnoreCase(charset) || "ISO-8859-1".equalsIgnoreCase(charset) ? 1 : 0) != 0);
            usedCharset = "UTF-8";
            charset = CharsetDetector.detectCharset((ByteArrayInputStream)new UnsynchronizedByteArrayInputStream("A text line \u00f6 \u00e4 \u00fc \u00df".getBytes(usedCharset)));
            MailCharsetDetectorTest.assertTrue((String)(usedCharset + " not detected" + charset), (boolean)usedCharset.equalsIgnoreCase(charset));
            usedCharset = "windows-1252";
            charset = CharsetDetector.detectCharset((ByteArrayInputStream)new UnsynchronizedByteArrayInputStream("A text line \u00f6 \u00e4 \u00fc \u00df".getBytes(usedCharset)));
            MailCharsetDetectorTest.assertTrue((String)(usedCharset + " not detected: " + charset), (boolean)usedCharset.equalsIgnoreCase(charset));
        }
        catch (Exception e) {
            e.printStackTrace();
            MailCharsetDetectorTest.fail((String)e.getMessage());
        }
    }
}

