/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.structure;

import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.structure.StructureHandler;
import com.openexchange.mail.structure.StructureMailMessageParser;
import com.openexchange.mail.structure.handler.MIMEStructureHandler;
import org.json.JSONArray;
import org.json.JSONObject;

public class MailUUEncodedStructureTest
extends AbstractMailTest {
    private static final byte[] SIMPLE = "Date: Mon, 2 Nov 2009 06:50:42 +0100 (CET)\nMessage-Id: <200911020550.nA25oglg029683@datacom.sender.com>\nSubject: \nTo: d.user@receiver.de\nFrom: datacom@sender.com\n\nDaten\n\nbegin 644 uuencode-Test.txt\nM1V5S8VAI8VAT90T*#0I$87,@554@<W1E:'0@9OQR(&1I92!7=7)Z96QN(&EN\nM(%5.25@N($1A<R!552!I;B!5565N8V]D92!U;F0@+61E8V]D92!S=&5H=\"`-\nM\"F5B96YS;R!W:64@9&%S(%55(&)E:2!556-P(&;\\<B!53DE8('1O(%5.25@@\nM8V]P>2!P<F]T;V-O;\"X@06QS;R!D:64@W&)E<G1R86=U;F<@#0IV;VX@96EN\nM96T@54Y)6\"U#;VUP=71E<B!Z=2!E:6YE;2!A;F1E<F5N(%5.25@M0V]M<'5T\n%97(N#0H`\n`\nend".getBytes();

    public MailUUEncodedStructureTest() {
    }

    public MailUUEncodedStructureTest(String name) {
        super(name);
    }

    public void testMIMEStructure() {
        try {
            this.getSession();
            MailMessage mail = MimeMessageConverter.convertMessage((byte[])SIMPLE);
            MIMEStructureHandler handler = new MIMEStructureHandler(-1L);
            new StructureMailMessageParser().parseMailMessage(mail, (StructureHandler)handler);
            JSONObject jsonMailObject = handler.getJSONMailObject();
            MailUUEncodedStructureTest.assertNotNull((String)"Structured JSON mail object is null.", (Object)jsonMailObject);
            Object bodyObject = jsonMailObject.opt("body");
            MailUUEncodedStructureTest.assertNotNull((String)"Missing mail body.", (Object)bodyObject);
            MailUUEncodedStructureTest.assertTrue((String)"Body object is not a JSON object.", (boolean)(bodyObject instanceof JSONObject));
            JSONObject headers = jsonMailObject.getJSONObject("headers");
            JSONObject ct = headers.getJSONObject("content-type");
            MailUUEncodedStructureTest.assertEquals((String)"Unexpected content type", (Object)"text/plain", (Object)ct.get("type"));
        }
        catch (Exception e) {
            e.printStackTrace();
            MailUUEncodedStructureTest.fail((String)e.getMessage());
        }
    }

    public void testMIMEStructureWithParsedUUEncodedParts() {
        try {
            this.getSession();
            MailMessage mail = MimeMessageConverter.convertMessage((byte[])SIMPLE);
            MIMEStructureHandler handler = new MIMEStructureHandler(-1L);
            new StructureMailMessageParser().setParseUUEncodedParts(true).parseMailMessage(mail, (StructureHandler)handler);
            JSONObject jsonMailObject = handler.getJSONMailObject();
            MailUUEncodedStructureTest.assertNotNull((String)"Structured JSON mail object is null.", (Object)jsonMailObject);
            Object bodyObject = jsonMailObject.opt("body");
            MailUUEncodedStructureTest.assertNotNull((String)"Missing mail body.", (Object)bodyObject);
            MailUUEncodedStructureTest.assertTrue((String)"Body object is not a JSON array.", (boolean)(bodyObject instanceof JSONArray));
            JSONArray jsonBodyObject = (JSONArray)bodyObject;
            JSONObject headers = jsonMailObject.getJSONObject("headers");
            JSONObject ct = headers.getJSONObject("content-type");
            MailUUEncodedStructureTest.assertEquals((String)"Unexpected content type", (Object)"multipart/mixed", (Object)ct.get("type"));
            MailUUEncodedStructureTest.assertEquals((String)"Unexpected number of parts", (int)2, (int)jsonBodyObject.length());
        }
        catch (Exception e) {
            e.printStackTrace();
            MailUUEncodedStructureTest.fail((String)e.getMessage());
        }
    }
}

