/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.structure;

import com.openexchange.configuration.MailConfig;
import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.structure.StructureHandler;
import com.openexchange.mail.structure.StructureMailMessageParser;
import com.openexchange.mail.structure.handler.MIMEStructureHandler;
import com.openexchange.tools.io.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.json.JSONObject;

public class Bug22735_StructureTest
extends AbstractMailTest {
    private byte[] smime;

    public Bug22735_StructureTest() {
    }

    public Bug22735_StructureTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        String testMailDir = MailConfig.getProperty(MailConfig.Property.TEST_MAIL_DIR);
        FileInputStream is = new FileInputStream(new File(testMailDir, "bug22735.eml"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.transfer((InputStream)is, (OutputStream)baos);
        ((InputStream)is).close();
        this.smime = baos.toByteArray();
        baos.close();
    }

    public void testMIMEStructure() {
        try {
            this.getSession();
            MailMessage mail = MimeMessageConverter.convertMessage((byte[])this.smime);
            MIMEStructureHandler handler = new MIMEStructureHandler(-1L);
            new StructureMailMessageParser().setParseTNEFParts(true).parseMailMessage(mail, (StructureHandler)handler);
            JSONObject jsonMailObject = handler.getJSONMailObject();
            Bug22735_StructureTest.assertNotNull((String)"Structured JSON mail object is null.", (Object)jsonMailObject);
            System.out.println(jsonMailObject.toString(2));
        }
        catch (Exception e) {
            e.printStackTrace();
            Bug22735_StructureTest.fail((String)e.getMessage());
        }
    }
}

