/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail;

import com.openexchange.exception.OXException;
import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.MailField;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.api.MailConfig;
import com.openexchange.mail.dataobjects.MailFolder;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.json.writer.FolderWriter;
import com.openexchange.mail.json.writer.MessageWriter;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.mail.utils.DisplayMode;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;

public final class MailParserWriterTest
extends AbstractMailTest {
    private static final MailField[] COMMON_LIST_FIELDS = new MailField[]{MailField.ID, MailField.FOLDER_ID, MailField.SIZE, MailField.FROM, MailField.TO, MailField.RECEIVED_DATE, MailField.SENT_DATE, MailField.SUBJECT, MailField.CONTENT_TYPE, MailField.FLAGS, MailField.PRIORITY, MailField.COLOR_LABEL};

    public MailParserWriterTest() {
    }

    public MailParserWriterTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMessageWriter() {
        try {
            SessionObject session = this.getSession();
            MailAccess mailConnection = MailAccess.getInstance((Session)session);
            mailConnection.connect();
            try {
                MailMessage[] mails;
                for (MailMessage mail : mails = mailConnection.getMessageStorage().getAllMessages("INBOX", null, null, null, new MailField[]{MailField.ID, MailField.CONTENT_TYPE})) {
                    if (!mail.getContentType().isMimeType("multipart/mixed")) continue;
                    System.out.println(MessageWriter.writeMailMessage((int)0, (MailMessage)mailConnection.getMessageStorage().getMessage("default.INBOX", mail.getMailId(), true), (DisplayMode)DisplayMode.DISPLAY, (boolean)false, (Session)session, (UserSettingMail)UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), session.getContextId())));
                    break;
                }
                for (MailMessage mail : mails) {
                    if (!mail.getContentType().isMimeType("multipart/alternative")) continue;
                    System.out.println(MessageWriter.writeMailMessage((int)0, (MailMessage)mailConnection.getMessageStorage().getMessage("default.INBOX", mail.getMailId(), true), (DisplayMode)DisplayMode.DISPLAY, (boolean)false, (Session)session, (UserSettingMail)UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), session.getContextId())));
                    break;
                }
            }
            finally {
                mailConnection.close(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MailParserWriterTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFolderWriter() {
        try {
            SessionObject session = this.getSession();
            MailAccess mailConnection = MailAccess.getInstance((Session)session);
            mailConnection.connect();
            ServerSession ss = ServerSessionAdapter.valueOf((Session)session);
            try {
                MailFolder root = mailConnection.getFolderStorage().getRootFolder();
                MailParserWriterTest.writeFolder(root, mailConnection, ss);
            }
            finally {
                mailConnection.close(true);
            }
        }
        catch (OXException e) {
            e.printStackTrace();
            MailParserWriterTest.fail((String)e.getMessage());
        }
    }

    private static void writeFolder(MailFolder f, MailAccess<?, ?> mailConnection, ServerSession session) throws OXException, OXException {
        MailFolder[] flds;
        System.out.println(FolderWriter.writeMailFolder((int)0, (MailFolder)f, (MailConfig)mailConnection.getMailConfig(), (ServerSession)session));
        for (MailFolder folder : flds = mailConnection.getFolderStorage().getSubfolders(f.getFullname(), true)) {
            MailParserWriterTest.writeFolder(folder, mailConnection, session);
        }
    }
}

