/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.calendarsqltests;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.calendarsqltests.CalendarSqlTest;
import com.openexchange.groupware.container.UserParticipant;
import java.sql.SQLException;
import java.util.Date;

public class Bug11424Test
extends CalendarSqlTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateInSharedFolderShouldAutoAcceptTimeChange() throws OXException, SQLException {
        this.folders.sharePrivateFolder(this.session, this.ctx, this.secondUserId);
        try {
            this.appointments.switchUser(this.secondUser);
            CalendarDataObject appointment = this.appointments.buildAppointmentWithUserParticipants(this.user);
            appointment.setParentFolderID(this.folders.getStandardFolder(this.userId, this.ctx));
            this.appointments.save(appointment);
            appointment = this.appointments.reload(appointment);
            boolean found = false;
            for (UserParticipant participant : appointment.getUsers()) {
                if (participant.getIdentifier() != this.userId) continue;
                found = true;
                Bug11424Test.assertEquals((int)1, (int)participant.getConfirm());
            }
            Bug11424Test.assertTrue((boolean)found);
            CalendarDataObject cdao = new CalendarDataObject();
            cdao.setStartDate(appointment.getStartDate());
            cdao.setEndDate(new Date(appointment.getEndDate().getTime() + 36000000L));
            cdao.setObjectID(appointment.getObjectID());
            cdao.setParentFolderID(appointment.getParentFolderID());
            cdao.setContext(appointment.getContext());
            this.appointments.save(cdao);
            appointment = this.appointments.reload(appointment);
            found = false;
            for (UserParticipant participant : appointment.getUsers()) {
                if (participant.getIdentifier() != this.userId) continue;
                found = true;
                Bug11424Test.assertEquals((int)1, (int)participant.getConfirm());
            }
            Bug11424Test.assertTrue((boolean)found);
        }
        finally {
            this.folders.unsharePrivateFolder(this.session, this.ctx);
        }
    }
}

