/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.calendarsqltests;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.calendarsqltests.CalendarSqlTest;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import java.util.ArrayList;

public class Bug11059Test
extends CalendarSqlTest {
    public void testShouldRespectReadPermissions() throws Exception {
        FolderObject folder = this.folders.createPublicFolderFor(this.session, this.ctx, "A nice public folder", 2, this.userId);
        this.cleanFolders.add(folder);
        boolean found = false;
        ArrayList<OCLPermission> permissions = new ArrayList<OCLPermission>(folder.getPermissions());
        for (OCLPermission permission : permissions) {
            if (0 != permission.getEntity()) continue;
            found = true;
            permission.setReadObjectPermission(0);
            permission.setWriteObjectPermission(0);
            permission.setDeleteObjectPermission(0);
            permission.setFolderPermission(8);
            permission.setGroupPermission(true);
        }
        if (!found) {
            OCLPermission permission = new OCLPermission();
            permission.setEntity(0);
            permission.setReadObjectPermission(0);
            permission.setWriteObjectPermission(0);
            permission.setDeleteObjectPermission(0);
            permission.setFolderPermission(8);
            permission.setGroupPermission(true);
            permissions.add(permission);
        }
        FolderObject update = new FolderObject();
        update.setObjectID(folder.getObjectID());
        update.setPermissions(permissions);
        this.folders.save(update, this.ctx, this.session);
        CalendarDataObject appointment = this.appointments.buildAppointmentWithUserParticipants(this.user, this.secondUser);
        appointment.setParentFolderID(folder.getObjectID());
        this.appointments.save(appointment);
        this.clean.add(appointment);
        this.appointments.switchUser(this.secondUser);
        try {
            this.appointments.getAppointmentsInFolder(folder.getObjectID());
            Bug11059Test.fail((String)"I could read the content!");
        }
        catch (OXException x) {
            Bug11059Test.assertTrue((boolean)x.getMessage().contains("APP-0013"));
        }
        try {
            this.appointments.getModifiedInFolder(folder.getObjectID(), 0L);
            Bug11059Test.fail((String)"I could read the content!");
        }
        catch (OXException x) {
            Bug11059Test.assertTrue((boolean)x.getMessage().contains("APP-0013"));
        }
        try {
            this.appointments.getDeletedInFolder(folder.getObjectID(), 0L);
            Bug11059Test.fail((String)"I could read the content!");
        }
        catch (OXException x) {
            Bug11059Test.assertTrue((boolean)x.getMessage().contains("APP-0013"));
        }
    }
}

