/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.task.AbstractTaskTest;
import com.openexchange.ajax.task.TaskTools;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.ajax.task.actions.UpdateRequest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.tasks.Create;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.java.util.TimeZones;
import java.io.IOException;
import java.util.Calendar;
import java.util.TimeZone;
import org.json.JSONException;

public final class Bug23444Test
extends AbstractTaskTest {
    private AJAXClient client;
    private Task task;
    private TimeZone tz;

    public Bug23444Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.tz = this.getTimeZone();
        this.task = Create.createWithDefaults(this.getPrivateFolder(), "Task to test for bug 23444");
        Calendar cal = TimeTools.createCalendar(TimeZones.UTC);
        cal.set(10, 0);
        this.task.setStartDate(cal.getTime());
        this.task.setEndDate(cal.getTime());
        this.task.setRecurrenceType(1);
        this.task.setInterval(1);
        InsertRequest request = new InsertRequest(this.task, this.tz);
        InsertResponse response = this.client.execute(request);
        response.fillTask(this.task);
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.task));
        super.tearDown();
    }

    public void testForBug() throws OXException, IOException, JSONException {
        Task update = TaskTools.valuesForUpdate(this.task);
        update.setRecurrenceType(0);
        UpdateRequest request = new UpdateRequest(update, this.tz);
        this.client.execute(request);
        GetResponse response = this.client.execute(new GetRequest(this.task, this.tz));
        Task test = response.getTask(this.tz);
        this.task.setLastModified(test.getLastModified());
        Bug23444Test.assertEquals((String)"Series information can not be removed from a task.", (int)0, (int)test.getRecurrenceType());
    }
}

