/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.contenttypes;

import com.openexchange.ajax.mail.TestMail;
import com.openexchange.ajax.mail.contenttypes.MailContentType;
import com.openexchange.ajax.mail.contenttypes.MailTypeStrategy;
import org.json.JSONException;

public class AlternativeStrategy
implements MailTypeStrategy {
    @Override
    public void sanitize(TestMail mail) throws JSONException {
        if (mail.getBody() == null && mail.getAttachment() != null) {
            String text = mail.getAttachment().get(0).getString("content");
            if (text.contains("<body>")) {
                text = text.split("<body>")[1];
                text = text.split("</body>")[0];
            }
            text = text.trim();
            mail.setBody(text);
            mail.setContentType(MailContentType.ALTERNATIVE.toString());
        }
    }

    @Override
    public boolean isResponsibleFor(TestMail mail) {
        return MailContentType.ALTERNATIVE.toString().equalsIgnoreCase(mail.getContentType());
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

