/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.recurrence.ManagedAppointmentTest;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.importexport.actions.ICalExportRequest;
import com.openexchange.ajax.importexport.actions.ICalExportResponse;
import com.openexchange.ajax.importexport.actions.ICalImportRequest;
import com.openexchange.ajax.importexport.actions.ICalImportResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public class Bug17392Test
extends ManagedAppointmentTest {
    protected Calendar calendar;
    protected int startHour = 13;
    protected int estOffset = -5;
    protected int edtOffset = -4;
    protected String start = "20101015T" + this.startHour + "0000";
    protected String end = "20101015T" + (this.startHour + 1) + "0000";

    public Bug17392Test(String name) {
        super(name);
    }

    public Appointment importAndGet(String ical) throws Exception {
        ICalImportRequest request = new ICalImportRequest(this.folder.getObjectID(), ical);
        ICalImportResponse response = this.getClient().execute(request);
        JSONArray data = (JSONArray)response.getData();
        Bug17392Test.assertEquals((int)1, (int)data.length());
        JSONObject jsonObject = data.getJSONObject(0);
        return this.calendarManager.get(jsonObject.getInt("folder_id"), jsonObject.getInt("id"));
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        this.calendar.set(1, 2010);
        this.calendar.set(2, 9);
        this.calendar.set(5, 15);
        this.calendar.set(14, 0);
        this.calendar.set(13, 0);
        this.calendar.set(12, 0);
        this.calendar.set(11, this.startHour);
    }

    public void testZuluTimezoneImport() throws Exception {
        String ical = "BEGIN:VCALENDAR\nVERSION:2.0\nBEGIN:VEVENT\nSUMMARY:Zulu-Time Appointment\nDTSTART:" + this.start + "Z\n" + "DTEND:" + this.end + "Z\n" + "END:VEVENT\n";
        Appointment app = this.importAndGet(ical);
        Date actualStart = app.getStartDate();
        this.calendar.setTime(actualStart);
        int actualHour = this.calendar.get(11);
        Bug17392Test.assertEquals((String)"Should not be shifted by time zones, because it is UTC/Zulu time", (int)this.startHour, (int)actualHour);
    }

    public void testTzidTimezoneImport() throws Exception {
        String ical = "BEGIN:VCALENDAR\nVERSION:2.0\nBEGIN:VEVENT\nSUMMARY: EST/New York Time Appointment\nDTSTART;TZID=America/New_York:" + this.start + "\n" + "DTEND;TZID=America/New_York:" + this.end + "\n" + "END:VEVENT\n";
        Appointment app = this.importAndGet(ical);
        Date actualStart = app.getStartDate();
        this.calendar.setTime(actualStart);
        int actualHour = this.calendar.get(11);
        Bug17392Test.assertEquals((String)"Should be shifted by +4 hours, because it was 1300 EDT originally", (int)(this.startHour - this.edtOffset), (int)actualHour);
    }

    public void testTzidExport() throws Exception {
        this.verifyTimezoneDoesNotGetLost("America/New_York");
        this.verifyTimezoneDoesNotGetLost("Europe/Berlin");
    }

    public void testRoundtripUTC() throws Exception {
        this.roundtrip("UTC");
    }

    public void testRoundtripNewYork() throws Exception {
        this.roundtrip("America/New_York");
    }

    public void testRoundtripBerlin() throws Exception {
        this.roundtrip("Europe/Berlin");
    }

    private void verifyTimezoneDoesNotGetLost(String tzid) throws OXException, IOException, SAXException, JSONException {
        Appointment app = new Appointment();
        app.setTimezone(tzid);
        app.setTitle("Appointment to be exported - this better contain a TZID!");
        app.setParentFolderID(this.folder.getObjectID());
        app.setStartDate(this.calendar.getTime());
        this.calendar.add(10, 1);
        app.setEndDate(this.calendar.getTime());
        this.calendarManager.insert(app);
        ICalExportRequest request = new ICalExportRequest(this.folder.getObjectID());
        ICalExportResponse response = this.getClient().execute(request);
        String ical = (String)response.getData();
        Bug17392Test.assertTrue((String)("Export should contain a TZID for " + tzid + System.getProperty("line.separator") + ical), (boolean)ical.contains("DTSTART;TZID=" + tzid));
    }

    public void roundtrip(String tzid) throws Exception {
        Calendar startingpoint = Calendar.getInstance(TimeZone.getTimeZone(tzid));
        startingpoint.set(1, 2010);
        startingpoint.set(2, 2);
        startingpoint.set(5, 5);
        startingpoint.set(11, this.startHour);
        Appointment app = new Appointment();
        app.setTimezone(tzid);
        app.setTitle("Appointment series to do a round-trip");
        app.setParentFolderID(this.folder.getObjectID());
        app.setStartDate(startingpoint.getTime());
        startingpoint.add(10, 1);
        app.setEndDate(startingpoint.getTime());
        app.setRecurrenceType(3);
        app.setRecurrenceCount(2);
        app.setInterval(1);
        app.setDayInMonth(startingpoint.get(5));
        this.calendarManager.insert(app);
        AJAXRequest<ICalExportResponse> request = new ICalExportRequest(this.folder.getObjectID());
        ICalExportResponse response = this.getClient().execute(request);
        String ical = (String)((AbstractAJAXResponse)response).getData();
        this.calendarManager.delete(app);
        request = new ICalImportRequest(this.folder.getObjectID(), ical);
        response = this.getClient().execute(request);
        JSONArray data = (JSONArray)((AbstractAJAXResponse)response).getData();
        Bug17392Test.assertEquals((int)1, (int)data.length());
        int objID = data.getJSONObject(0).getInt("id");
        TimeZone appointmentTz = TimeZone.getTimeZone(tzid);
        Calendar wintertime = Calendar.getInstance(appointmentTz);
        request = new GetRequest(this.folder.getObjectID(), objID, true);
        response = this.getClient().execute(request);
        Appointment winterApp = ((GetResponse)((Object)response)).getAppointment(appointmentTz);
        wintertime.setTime(winterApp.getStartDate());
        request = new GetRequest(this.folder.getObjectID(), objID, 2, true);
        response = this.getClient().execute(request);
        Appointment summerApp = ((GetResponse)((Object)response)).getAppointment(appointmentTz);
        Calendar summertime = Calendar.getInstance(appointmentTz);
        summertime.setTime(summerApp.getStartDate());
        TimeZone userTz = this.getClient().getValues().getTimeZone();
        int userTzOffset = userTz.getOffset(winterApp.getStartDate().getTime()) / 1000 / 60 / 60;
        int appTzOffset = appointmentTz.getOffset(winterApp.getStartDate().getTime()) / 1000 / 60 / 60;
        Bug17392Test.assertEquals((String)"Precondition: First occurrence should be in March", (int)2, (int)wintertime.get(2));
        Bug17392Test.assertEquals((String)"Precondition: Second occurrence should be in April", (int)3, (int)summertime.get(2));
        Bug17392Test.assertEquals((String)("First date (during wintertime) on " + tzid + " should be at"), (int)(this.startHour + userTzOffset), (int)(wintertime.get(11) + appTzOffset));
        Bug17392Test.assertEquals((String)("Second date (during summer time) on " + tzid + " should be at"), (int)(this.startHour + userTzOffset), (int)(summertime.get(11) + appTzOffset));
    }
}

