/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.framework;

import com.openexchange.ajax.LoginServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;

public abstract class AbstractRedirectParser<T extends AbstractAJAXResponse>
extends AbstractAJAXParser<T> {
    private final boolean cookiesNeeded;
    private final boolean failOnNonRedirect;
    private String location;
    private int statusCode;
    private String reasonPhrase;

    protected AbstractRedirectParser() {
        this(true);
    }

    protected AbstractRedirectParser(boolean cookiesNeeded) {
        this(cookiesNeeded, true);
    }

    protected AbstractRedirectParser(boolean cookiesNeeded, boolean failOnNonRedirect) {
        super(true);
        this.cookiesNeeded = cookiesNeeded;
        this.failOnNonRedirect = failOnNonRedirect;
    }

    protected int getStatusCode() {
        return this.statusCode;
    }

    protected void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    protected String getReasonPhrase() {
        return this.reasonPhrase;
    }

    protected void setReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
    }

    @Override
    protected Response getResponse(String body) throws JSONException {
        throw new JSONException("Method not supported when parsing redirect responses.");
    }

    @Override
    public String checkResponse(HttpResponse resp) throws ParseException, IOException {
        this.statusCode = resp.getStatusLine().getStatusCode();
        this.reasonPhrase = resp.getStatusLine().getReasonPhrase();
        if (this.failOnNonRedirect) {
            AbstractRedirectParser.assertEquals((String)"Response code is not okay.", (int)302, (int)this.statusCode);
        } else if (this.statusCode >= 400) {
            return Integer.toString(this.statusCode) + (null == this.reasonPhrase ? "" : this.reasonPhrase);
        }
        Header[] headers = resp.getHeaders("Location");
        AbstractRedirectParser.assertEquals((String)"There should be exactly one Location header.", (int)1, (int)headers.length);
        this.location = headers[0].getValue();
        AbstractRedirectParser.assertNotNull((String)"Location for redirect is missing.", (Object)this.location);
        if (this.cookiesNeeded) {
            boolean oxCookieFound = false;
            boolean jsessionIdCookieFound = false;
            BasicHeaderElementIterator iter = new BasicHeaderElementIterator(resp.headerIterator("Set-Cookie"));
            while (iter.hasNext()) {
                HeaderElement element = iter.nextElement();
                if (element.getName().startsWith(LoginServlet.SECRET_PREFIX)) {
                    oxCookieFound = true;
                    continue;
                }
                if (!"JSESSIONID".equals(element.getName())) continue;
                jsessionIdCookieFound = true;
            }
            AbstractRedirectParser.assertTrue((String)"Session cookie is missing.", (boolean)oxCookieFound);
            AbstractRedirectParser.assertTrue((String)"JSESSIONID cookie is missing.", (boolean)jsessionIdCookieFound);
        }
        return EntityUtils.toString((HttpEntity)resp.getEntity());
    }

    @Override
    public final T parse(String body) throws JSONException {
        return this.createResponse(null == this.location ? body : this.location);
    }

    @Override
    protected final T createResponse(Response response) {
        return null;
    }

    protected abstract T createResponse(String var1) throws JSONException;
}

