/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.recurrence;

import com.openexchange.ajax.appointment.action.AllRequest;
import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public final class Bug14074Test
extends AbstractAJAXSession {
    private static final int[] COLUMNS = new int[]{1, 207};
    private TimeZone tz;
    private int folderId;
    private Appointment appointment;

    public Bug14074Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        AJAXClient client = this.getClient();
        this.tz = client.getValues().getTimeZone();
        this.folderId = client.getValues().getPrivateAppointmentFolder();
        this.appointment = this.createAppointment();
        InsertRequest request = new InsertRequest(this.appointment, this.tz);
        AppointmentInsertResponse response = client.execute(request);
        response.fillAppointment(this.appointment);
    }

    @Override
    protected void tearDown() throws Exception {
        DeleteRequest request = new DeleteRequest(this.appointment);
        this.getClient().execute(request);
        super.tearDown();
    }

    public void testDailyFullTimeUntil() throws Throwable {
        AJAXClient client = this.getClient();
        Appointment changed = this.changeAppointment();
        UpdateResponse response = client.execute(new UpdateRequest(changed, this.tz));
        this.appointment.setLastModified(response.getTimestamp());
        Calendar calendar = TimeTools.createCalendar(this.tz, 2009, 6, 6, 0);
        Date start = calendar.getTime();
        calendar.add(5, 7);
        Date end = calendar.getTime();
        CommonAllResponse allResponse = client.execute(new AllRequest(this.folderId, COLUMNS, start, end, this.tz, false));
        int recurrencePosition = -1;
        for (Object[] obj : allResponse) {
            if (this.appointment.getObjectID() != ((Integer)obj[0]).intValue()) continue;
            recurrencePosition = (Integer)obj[1];
        }
        Bug14074Test.assertFalse((String)"Changed appointment not found.", (-1 == recurrencePosition ? 1 : 0) != 0);
        GetResponse getResponse = client.execute(new GetRequest(this.folderId, this.appointment.getObjectID(), recurrencePosition));
        Appointment toTest = getResponse.getAppointment(this.tz);
        Bug14074Test.assertEquals((String)"Start date is not 1400.", (Object)changed.getStartDate(), (Object)toTest.getStartDate());
        Bug14074Test.assertEquals((String)"Start date is not 1500.", (Object)changed.getEndDate(), (Object)toTest.getEndDate());
    }

    private Appointment createAppointment() {
        Appointment appointment = new Appointment();
        appointment.setTitle("test for bug 14074");
        appointment.setParentFolderID(this.folderId);
        Calendar calendar = TimeTools.createCalendar(this.tz, 2009, 0, 23, 13);
        appointment.setStartDate(calendar.getTime());
        calendar.add(11, 1);
        appointment.setEndDate(calendar.getTime());
        appointment.setIgnoreConflicts(true);
        appointment.setRecurrenceType(2);
        appointment.setInterval(1);
        appointment.setDays(32);
        return appointment;
    }

    private Appointment changeAppointment() {
        Appointment changed = new Appointment();
        changed.setTitle("test for bug 14074 changed");
        changed.setParentFolderID(this.folderId);
        changed.setObjectID(this.appointment.getObjectID());
        changed.setLastModified(this.appointment.getLastModified());
        Calendar calendar = TimeTools.createCalendar(this.tz, 2009, 6, 10, 14);
        changed.setStartDate(calendar.getTime());
        calendar.add(11, 1);
        changed.setEndDate(calendar.getTime());
        changed.setRecurrenceType(2);
        changed.setInterval(1);
        changed.setDays(32);
        return changed;
    }
}

