/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.util;

import javax.mail.util.LimitExceededException;

public class LimitedStringBuilder
implements Appendable,
CharSequence {
    private final int limit;
    private final StringBuilder sb;

    public LimitedStringBuilder(int limit) {
        this.limit = limit;
        this.sb = new StringBuilder(limit + 8);
    }

    @Override
    public int length() {
        return this.sb.length();
    }

    public LimitedStringBuilder appendDots() {
        this.sb.append("...");
        return this;
    }

    private LimitExceededException newLimitExceededException() {
        return new LimitExceededException("Exceeded limit of " + this.limit + " characters.");
    }

    private void checkLimit(CharSequence s) {
        if (this.sb.length() + s.length() > this.limit) {
            throw this.newLimitExceededException();
        }
    }

    public LimitedStringBuilder append(Object obj) {
        String s = String.valueOf(obj);
        this.checkLimit(s);
        this.sb.append(s);
        return this;
    }

    public LimitedStringBuilder append(String str) {
        String s = null == str ? "null" : str;
        this.checkLimit(s);
        this.sb.append(s);
        return this;
    }

    @Override
    public char charAt(int index) {
        return this.sb.charAt(index);
    }

    @Override
    public LimitedStringBuilder append(CharSequence cs) {
        CharSequence s = null == cs ? "null" : cs;
        this.checkLimit(s);
        this.sb.append(s);
        return this;
    }

    @Override
    public LimitedStringBuilder append(CharSequence cs, int start, int end) {
        CharSequence s;
        CharSequence charSequence = s = null == cs ? "null" : cs;
        if (this.sb.length() + (end - start) > this.limit) {
            throw this.newLimitExceededException();
        }
        this.sb.append(s, start, end);
        return this;
    }

    public LimitedStringBuilder append(char[] str) {
        if (null == str) {
            return this.append("null");
        }
        if (this.sb.length() + str.length > this.limit) {
            throw this.newLimitExceededException();
        }
        this.sb.append(str);
        return this;
    }

    public LimitedStringBuilder append(char[] str, int offset, int len) {
        if (null == str) {
            return this.append("null");
        }
        if (this.sb.length() + (len - offset) > this.limit) {
            throw this.newLimitExceededException();
        }
        this.sb.append(str, offset, len);
        return this;
    }

    public LimitedStringBuilder append(boolean b) {
        String s = String.valueOf(b);
        this.checkLimit(s);
        this.sb.append(s);
        return this;
    }

    @Override
    public LimitedStringBuilder append(char c) {
        String s = String.valueOf(c);
        this.checkLimit(s);
        this.sb.append(s);
        return this;
    }

    public LimitedStringBuilder append(int i) {
        String s = String.valueOf(i);
        this.checkLimit(s);
        this.sb.append(s);
        return this;
    }

    public int codePointBefore(int index) {
        return this.sb.codePointBefore(index);
    }

    public LimitedStringBuilder append(long lng) {
        String s = String.valueOf(lng);
        this.checkLimit(s);
        this.sb.append(s);
        return this;
    }

    public LimitedStringBuilder append(float f) {
        String s = String.valueOf(f);
        this.checkLimit(s);
        this.sb.append(s);
        return this;
    }

    public LimitedStringBuilder append(double d) {
        String s = String.valueOf(d);
        this.checkLimit(s);
        this.sb.append(s);
        return this;
    }

    public LimitedStringBuilder delete(int start, int end) {
        this.sb.delete(start, end);
        return this;
    }

    public LimitedStringBuilder deleteCharAt(int index) {
        this.sb.deleteCharAt(index);
        return this;
    }

    @Override
    public String toString() {
        return this.sb.toString();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.sb.subSequence(start, end);
    }
}

