/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.resources;

import com.openexchange.webdav.protocol.Protocol;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import com.openexchange.webdav.xml.resources.PropertiesMarshaller;
import com.openexchange.webdav.xml.resources.ResourceMarshaller;
import java.util.LinkedList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class RecursiveMarshaller
implements ResourceMarshaller {
    private final PropertiesMarshaller delegate;
    private final int depth;
    private final int limit;

    public RecursiveMarshaller(PropertiesMarshaller delegate, int depth, int limit) {
        this.delegate = delegate;
        this.depth = depth;
        this.limit = limit;
    }

    @Override
    public List<Element> marshal(WebdavResource resource) throws WebdavProtocolException {
        LinkedList<Element> elements = new LinkedList<Element>();
        elements.addAll(this.delegate.marshal(resource));
        if (resource.isCollection()) {
            for (WebdavResource childResource : resource.toCollection().toIterable(this.depth)) {
                elements.addAll(this.delegate.marshal(childResource));
                if (elements.size() <= this.limit) continue;
                elements.add(this.getInsufficientStorageResponse(resource));
                break;
            }
        }
        return elements;
    }

    private Element getInsufficientStorageResponse(WebdavResource resource) {
        Element response = new Element("response", Protocol.DAV_NS);
        response.addContent((Content)this.delegate.marshalHREF(resource.getUrl(), resource.isCollection()));
        Element status = this.delegate.marshalStatus(507);
        status.setText("HTTP/1.1 507 Insufficient Storage");
        response.addContent((Content)status);
        Element error = new Element("error", Protocol.DAV_NS);
        error.addContent((Content)new Element("number-of-matches-within-limits", Protocol.DAV_NS));
        response.addContent((Content)error);
        return response;
    }
}

