/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder.permissionLoader;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class Gate {
    private final transient AtomicReference<GateState> gate = new AtomicReference<GateState>(GateState.CLOSED);
    private final transient PassChecker passChecker;
    private final transient Lock lock;
    private final transient Condition available;

    public Gate(int maxParallelPasses) {
        this.passChecker = maxParallelPasses > 0 ? new LimitedPassChecker(maxParallelPasses) : new InfinitePassChecker();
        this.lock = new ReentrantLock();
        this.available = this.lock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pass() throws InterruptedException {
        if (GateState.CLOSED == this.gate.get()) {
            Lock lock = this.lock;
            lock.lock();
            try {
                this.available.await();
            }
            finally {
                lock.unlock();
            }
        }
        this.passChecker.pass();
    }

    public boolean tryPass() {
        if (GateState.CLOSED == this.gate.get()) {
            return false;
        }
        return this.passChecker.tryPass();
    }

    public void signalDone() {
        this.passChecker.signalDone();
    }

    public boolean close() {
        GateState gateState;
        do {
            if (GateState.CLOSED != (gateState = this.gate.get())) continue;
            return false;
        } while (!this.gate.compareAndSet(gateState, GateState.CLOSED));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open() {
        GateState gateState;
        do {
            if (GateState.OPEN != (gateState = this.gate.get())) continue;
            return false;
        } while (!this.gate.compareAndSet(gateState, GateState.OPEN));
        Lock lock = this.lock;
        lock.lock();
        try {
            this.available.signalAll();
        }
        finally {
            lock.unlock();
        }
        return true;
    }

    private static final class LimitedPassChecker
    implements PassChecker {
        private final Semaphore semaphore;

        public LimitedPassChecker(int permits) {
            this.semaphore = new Semaphore(permits);
        }

        @Override
        public void pass() throws InterruptedException {
            this.semaphore.acquire();
        }

        @Override
        public boolean tryPass() {
            return this.semaphore.tryAcquire();
        }

        @Override
        public void signalDone() {
            this.semaphore.release();
        }
    }

    private static final class InfinitePassChecker
    implements PassChecker {
        @Override
        public void pass() {
        }

        @Override
        public void signalDone() {
        }

        @Override
        public boolean tryPass() {
            return true;
        }
    }

    private static interface PassChecker {
        public boolean tryPass();

        public void pass() throws InterruptedException;

        public void signalDone();
    }

    private static enum GateState {
        OPEN,
        CLOSED;

    }
}

