/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder;

import com.openexchange.api2.AppointmentSQLInterface;
import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.contact.ContactService;
import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.AppointmentSqlFactoryService;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.infostore.facade.impl.InfostoreFacadeImpl;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.tasks.Tasks;
import com.openexchange.groupware.tools.iterator.FolderObjectIterator;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.groupware.userconfiguration.UserPermissionBitsStorage;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.StringCollection;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorAdapter;
import com.openexchange.tools.iterator.SearchIteratorException;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderProperties;
import com.openexchange.tools.oxfolder.OXFolderUtility;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

@Deprecated
public class OXFolderTools {
    private static final String STR_EMPTY = "";
    private static final String SQL_SEL_DEFFLD = "SELECT fuid FROM oxfolder_tree WHERE cid = ? AND created_from = ? AND default_flag = ? AND module = ?";
    private static final String SQL_SELECT_FOLDERS_START = new StringBuilder(200).append("SELECT ").append(FolderObjectIterator.getFieldsForSQL("ot")).append(" FROM oxfolder_tree AS ot").append(" WHERE (cid = ?) ").toString();

    private OXFolderTools() {
    }

    public static int getFolderTypeFromDB(int folderId, int userId, UserConfiguration userConfig, Context ctx) throws OXException {
        return OXFolderTools.getFolderTypeFromDB(folderId, userId, userConfig, ctx, null);
    }

    public static int getFolderTypeFromDB(int folderId, int userId, UserConfiguration userConfig, Context ctx, Connection readCon) throws OXException {
        try {
            FolderObject fo = FolderCacheManager.isEnabled() ? FolderCacheManager.getInstance().getFolderObject(folderId, false, ctx, readCon) : FolderObject.loadFolderObjectFromDB(folderId, ctx, readCon);
            if (!fo.getEffectiveUserPermission(userId, userConfig).isFolderVisible()) {
                throw OXFolderExceptionCode.NOT_VISIBLE.create(folderId, userId, ctx.getContextId());
            }
            return fo.getType(userId);
        }
        catch (RuntimeException e) {
            throw OXFolderExceptionCode.FOLDER_COULD_NOT_BE_LOADED.create(folderId, ctx.getContextId(), e);
        }
        catch (OXException e) {
            throw OXFolderExceptionCode.FOLDER_COULD_NOT_BE_LOADED.create(new Object[]{folderId, ctx.getContextId(), e});
        }
    }

    public static EffectivePermission getEffectiveFolderOCL(int folderId, int userId, int[] groups, Context ctx, UserConfiguration userConfig, Connection con) throws OXException {
        return OXFolderTools.getEffectiveFolderOCL(folderId, userId, groups, ctx, userConfig, con, true);
    }

    public static EffectivePermission getEffectiveFolderOCL(int folderId, int userId, int[] groups, Context ctx, UserConfiguration userConfig) throws OXException {
        return OXFolderTools.getEffectiveFolderOCL(folderId, userId, groups, ctx, userConfig, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EffectivePermission getEffectiveFolderOCL(int folderId, int userId, int[] groups, Context ctx, UserConfiguration userConfig, Connection con, boolean fromCache) throws OXException {
        FolderObject folderObj;
        if (fromCache && FolderCacheManager.isEnabled() && (folderObj = new OXFolderAccess(con, ctx).getFolderObject(folderId)) != null) {
            try {
                return folderObj.getEffectiveUserPermission(userId, userConfig);
            }
            catch (RuntimeException e) {
                throw OXFolderExceptionCode.FOLDER_COULD_NOT_BE_LOADED.create(e, OXFolderUtility.getFolderName(folderId, ctx), ctx.getContextId(), e);
            }
            catch (OXException e) {
                throw OXFolderExceptionCode.FOLDER_COULD_NOT_BE_LOADED.create(e, new Object[]{OXFolderUtility.getFolderName(folderId, ctx), ctx.getContextId(), e});
            }
        }
        EffectivePermission retval = new EffectivePermission(userId, folderId, OXFolderTools.getFolderTypeFromDB(folderId, userId, userConfig, ctx, con), OXFolderTools.getFolderModule(folderId, ctx, con), OXFolderTools.getFolderOwner(folderId, ctx, con), userConfig);
        retval.setEntity(userId);
        retval.setAllPermission(0, 0, 0, 0);
        Connection readCon = con;
        boolean closeCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                String permissionIds = StringCollection.getSqlInString(userId, groups);
                String sqlSelectStr = "SELECT fp, orp, owp, odp, admin_flag, group_flag FROM oxfolder_permissions WHERE (cid = ?) AND (fuid = ?) AND permission_id IN " + permissionIds;
                if (readCon == null) {
                    readCon = DBPool.pickup(ctx);
                    closeCon = true;
                }
                stmt = readCon.prepareStatement(sqlSelectStr);
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, folderId);
                rs = stmt.executeQuery();
                int fp_highest = 0;
                int orp_highest = 0;
                int owp_highest = 0;
                int odp_highest = 0;
                boolean folderAdmin = false;
                while (rs.next()) {
                    int fp = rs.getInt(1);
                    if (!rs.wasNull()) {
                        fp_highest = Math.max(fp_highest, fp);
                    }
                    int orp = rs.getInt(2);
                    if (!rs.wasNull()) {
                        orp_highest = Math.max(orp_highest, orp);
                    }
                    int owp = rs.getInt(3);
                    if (!rs.wasNull()) {
                        owp_highest = Math.max(owp_highest, owp);
                    }
                    int odp = rs.getInt(4);
                    if (!rs.wasNull()) {
                        odp_highest = Math.max(odp_highest, odp);
                    }
                    if (folderAdmin) continue;
                    folderAdmin = rs.getInt(5) > 0;
                }
                if (!retval.setAllPermission(fp_highest, orp_highest, owp_highest, odp_highest)) {
                    throw OXFolderExceptionCode.NO_EFFECTIVE_PERMISSION.create(folderId, userId, ctx.getContextId());
                }
                retval.setFolderAdmin(folderAdmin);
                DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            }
            catch (Throwable throwable) {
                DBUtils.closeResources(rs, stmt, closeCon ? readCon : null, true, ctx);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (Throwable t) {
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
        return retval;
    }

    public static int getDefaultFolder(int user, int module, Context ctx) throws OXException {
        return OXFolderTools.getDefaultFolder(user, module, ctx, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDefaultFolder(int user, int module, Context ctx, Connection con) throws OXException {
        Connection readCon = con;
        boolean closeCon = false;
        int retval = 0;
        try {
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                if (readCon == null) {
                    readCon = DBPool.pickup(ctx);
                    closeCon = true;
                }
                if (module == 2 || module == 1 || module == 3 || module == 8) {
                    String sqlSelectStr = SQL_SEL_DEFFLD;
                    stmt = readCon.prepareStatement(SQL_SEL_DEFFLD);
                    stmt.setInt(1, ctx.getContextId());
                    stmt.setInt(2, user);
                    stmt.setInt(3, 1);
                    stmt.setInt(4, module);
                } else {
                    String sqlSelectStr = "SELECT fuid FROM oxfolder_userfolders_standardfolders WHERE cid = ? AND created_from = ? AND module = ?";
                    stmt = readCon.prepareStatement("SELECT fuid FROM oxfolder_userfolders_standardfolders WHERE cid = ? AND created_from = ? AND module = ?");
                    stmt.setInt(1, ctx.getContextId());
                    stmt.setInt(2, user);
                    stmt.setInt(3, module);
                }
                rs = stmt.executeQuery();
                if (rs.next()) {
                    retval = rs.getInt(1);
                }
                DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            }
            catch (Throwable throwable) {
                DBUtils.closeResources(rs, stmt, closeCon ? readCon : null, true, ctx);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (Throwable t) {
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
        if (retval != 0) {
            return retval;
        }
        throw OXFolderExceptionCode.NO_DEFAULT_FOLDER_FOUND.create(OXFolderUtility.folderModule2String(module), OXFolderUtility.getUserName(user, ctx), ctx.getContextId());
    }

    public static int getContactDefaultFolder(int user, Context ctx) throws OXException {
        return OXFolderTools.getDefaultFolder(user, ctx, null, 3);
    }

    public static int getContactDefaultFolder(int user, Context ctx, Connection con) throws OXException {
        return OXFolderTools.getDefaultFolder(user, ctx, con, 3);
    }

    public static int getTaskDefaultFolder(int user, Context ctx) throws OXException {
        return OXFolderTools.getDefaultFolder(user, ctx, null, 1);
    }

    public static int getTaskDefaultFolder(int user, Context ctx, Connection con) throws OXException {
        return OXFolderTools.getDefaultFolder(user, ctx, con, 1);
    }

    public static int getCalendarDefaultFolder(int user, Context ctx) throws OXException {
        return OXFolderTools.getDefaultFolder(user, ctx, null, 2);
    }

    public static int getCalendarDefaultFolder(int user, Context ctx, Connection con) throws OXException {
        return OXFolderTools.getDefaultFolder(user, ctx, con, 2);
    }

    public static int getInfostoreDefaultFolder(int user, Context ctx) throws OXException {
        return OXFolderTools.getDefaultFolder(user, ctx, null, 8);
    }

    public static int getInfostoreDefaultFolder(int user, Context ctx, Connection con) throws OXException {
        return OXFolderTools.getDefaultFolder(user, ctx, con, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int getDefaultFolder(int user, Context ctx, Connection readConArg, int module) throws OXException {
        int retval = 0;
        Connection readCon = readConArg;
        boolean closeCon = false;
        try {
            if (readCon == null) {
                readCon = DBPool.pickup(ctx);
                closeCon = true;
            }
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = readCon.prepareStatement(SQL_SEL_DEFFLD);
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, user);
                stmt.setInt(3, 1);
                stmt.setInt(4, module);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    retval = rs.getInt(1);
                    if (rs.wasNull()) {
                        throw OXFolderExceptionCode.NO_DEFAULT_FOLDER_FOUND.create(OXFolderUtility.folderModule2String(module), OXFolderUtility.getUserName(user, ctx), ctx.getContextId());
                    }
                } else {
                    throw OXFolderExceptionCode.NO_DEFAULT_FOLDER_FOUND.create(OXFolderUtility.folderModule2String(module), OXFolderUtility.getUserName(user, ctx), ctx.getContextId());
                }
                DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            }
            catch (Throwable throwable) {
                DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (Throwable t) {
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
        return retval;
    }

    public static boolean isFolderCalendar(int folderId, Context ctx, Connection readCon) throws OXException {
        FolderObject folderObj = new OXFolderAccess(readCon, ctx).getFolderObject(folderId);
        return folderObj != null && folderObj.getModule() == 2;
    }

    public static boolean isFolderContact(int folderId, Context ctx, Connection readCon) throws OXException {
        FolderObject folderObj = new OXFolderAccess(readCon, ctx).getFolderObject(folderId);
        return folderObj != null && folderObj.getModule() == 3;
    }

    public static boolean isFolderTask(int folderId, Context ctx, Connection readCon) throws OXException {
        FolderObject folderObj = new OXFolderAccess(readCon, ctx).getFolderObject(folderId);
        return folderObj != null && folderObj.getModule() == 1;
    }

    public static boolean isFolderPrivate(int folderId, Context ctx, Connection readCon) throws OXException {
        FolderObject folderObj = new OXFolderAccess(readCon, ctx).getFolderObject(folderId);
        return folderObj != null && folderObj.getType() == 1;
    }

    public static boolean isFolderPublic(int folderId, Context ctx, Connection readCon) throws OXException {
        FolderObject folderObj = new OXFolderAccess(readCon, ctx).getFolderObject(folderId);
        return folderObj != null && folderObj.getType() == 2;
    }

    public static boolean isFolderShared(int folderId, String user, Context ctx, Connection readCon) throws OXException {
        return OXFolderTools.isFolderShared(folderId, Integer.parseInt(user), ctx, readCon);
    }

    public static boolean isFolderShared(int folderId, int user, Context ctx, Connection readCon) throws OXException {
        FolderObject folderObj = new OXFolderAccess(readCon, ctx).getFolderObject(folderId);
        return folderObj != null && folderObj.getType() == 1 && folderObj.getCreator() != user;
    }

    public static int getFolderModule(int folderId, Context ctx) throws OXException {
        return OXFolderTools.getFolderModule(folderId, ctx, null);
    }

    public static int getFolderModule(int folderId, Context ctx, Connection readCon) throws OXException {
        FolderObject folderObj = new OXFolderAccess(readCon, ctx).getFolderObject(folderId);
        return folderObj.getModule();
    }

    public static int getFolderType(int folderId, int user, Context ctx) throws OXException {
        return OXFolderTools.getFolderType(folderId, user, ctx, null);
    }

    public static int getFolderType(int folderId, int user, Context ctx, Connection readCon) throws OXException {
        FolderObject folderObj = new OXFolderAccess(readCon, ctx).getFolderObject(folderId);
        return folderObj.isShared(user) ? 3 : folderObj.getType();
    }

    public static int getFolderType(int folderId, Context ctx, Connection readCon) throws OXException {
        FolderObject folderObj = new OXFolderAccess(readCon, ctx).getFolderObject(folderId);
        return folderObj.getType();
    }

    public static int getFolderOwner(int folderId, Context ctx, Connection readCon) throws OXException {
        FolderObject folderObj = new OXFolderAccess(readCon, ctx).getFolderObject(folderId);
        return folderObj.getCreator();
    }

    public static boolean getFolderDefaultFlag(int folderId, Context ctx, Connection readCon) throws OXException {
        FolderObject folderObj = new OXFolderAccess(readCon, ctx).getFolderObject(folderId);
        return folderObj.isDefaultFolder();
    }

    public static String getFolderName(int folderId, Context ctx, Connection readCon) throws OXException {
        FolderObject folderObj = new OXFolderAccess(readCon, ctx).getFolderObject(folderId);
        return folderObj.getFolderName();
    }

    public static int getFolderParent(int folderId, Context ctx, Connection readCon) throws OXException {
        FolderObject folderObj = new OXFolderAccess(readCon, ctx).getFolderObject(folderId);
        return folderObj.getParentFolderID();
    }

    private static final String getSQLUserVisibleFolders(String fields, String permissionIds, String accessibleModules, String additionalCondition, String groupBy, String orderBy) {
        StringBuilder retValBuilder = new StringBuilder("SELECT ").append(fields).append(" FROM oxfolder_tree AS ot ").append("JOIN oxfolder_permissions AS op ON ot.fuid = op.fuid AND ot.cid = ? AND op.cid = ? ").append("WHERE (((ot.permission_flag = ").append(1).append(" AND ot.created_from = ?)) OR ").append("((op.admin_flag = 1 AND op.permission_id = ?) OR (op.fp > ").append(0).append(" AND op.permission_id IN ").append(permissionIds).append(")))");
        if (OXFolderProperties.isIgnoreSharedAddressbook()) {
            retValBuilder.append(" AND (ot.fuid !=").append(5).append(')');
        }
        if (accessibleModules != null) {
            retValBuilder.append(" AND (ot.module IN ").append(accessibleModules).append(')');
        }
        if (additionalCondition != null) {
            retValBuilder.append(' ').append(additionalCondition);
        }
        if (groupBy != null) {
            retValBuilder.append(' ').append(groupBy);
        }
        if (orderBy != null) {
            retValBuilder.append(' ').append(orderBy);
        }
        return retValBuilder.toString();
    }

    public static SearchIterator getUserRootFoldersIterator(int userId, int[] memberInGroups, int[] accessibleModules, Context ctx) throws OXException, SearchIteratorException {
        String sqlSelectStr = OXFolderTools.getSQLUserVisibleFolders(FolderObjectIterator.getFieldsForSQL("ot"), StringCollection.getSqlInString(userId, memberInGroups), StringCollection.getSqlInString(accessibleModules), "AND (ot.type = ?) AND (ot.parent = ?)", OXFolderProperties.isEnableDBGrouping() ? "GROUP BY ot.fuid" : null, "ORDER by ot.fuid");
        Connection readCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            readCon = DBPool.pickup(ctx);
            stmt = readCon.prepareStatement(sqlSelectStr);
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, ctx.getContextId());
            stmt.setInt(3, userId);
            stmt.setInt(4, userId);
            stmt.setInt(5, 5);
            stmt.setInt(6, 0);
            rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw e;
        }
        catch (Throwable t) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
        return new FolderObjectIterator(rs, stmt, true, ctx, readCon, true);
    }

    public static SearchIterator getVisibleSubfoldersIterator(int parentFolderId, int userId, int[] groups, Context ctx, UserConfiguration userConfig, Timestamp since) throws SQLException, OXException, OXException, SearchIteratorException {
        if (parentFolderId == 1) {
            return OXFolderTools.getVisiblePrivateFolders(userId, groups, userConfig.getAccessibleModules(), ctx, since);
        }
        if (parentFolderId == 2) {
            return OXFolderTools.getVisiblePublicFolders(userId, groups, userConfig.getAccessibleModules(), ctx, since);
        }
        if (parentFolderId == 3) {
            return OXFolderTools.getVisibleSharedFolders(userId, groups, userConfig.getAccessibleModules(), ctx, since);
        }
        FolderObject parentFolder = new OXFolderAccess(ctx).getFolderObject(parentFolderId);
        EffectivePermission effectivePerm = parentFolder.getEffectiveUserPermission(userId, userConfig);
        if (((OCLPermission)effectivePerm).getFolderPermission() < 2) {
            return SearchIteratorAdapter.emptyIterator();
        }
        return OXFolderTools.getVisibleSubfoldersIterator(parentFolder, userId, groups, userConfig.getAccessibleModules(), ctx, since);
    }

    private static SearchIterator getVisiblePrivateFolders(int userId, int[] groups, int[] accessibleModules, Context ctx, Timestamp since) throws OXException, SearchIteratorException {
        StringBuilder condBuilder = new StringBuilder("AND (ot.type = ").append(1).append(" AND ot.created_from = ").append(userId).append(") AND (ot.parent = ?)").append(since == null ? STR_EMPTY : " AND (changing_date > ?)");
        String sqlSelectStr = OXFolderTools.getSQLUserVisibleFolders(FolderObjectIterator.getFieldsForSQL("ot"), StringCollection.getSqlInString(userId, groups), StringCollection.getSqlInString(accessibleModules), condBuilder.toString(), OXFolderProperties.isEnableDBGrouping() ? "GROUP BY ot.fuid" : null, "ORDER by ot.fuid");
        Connection readCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            readCon = DBPool.pickup(ctx);
            stmt = readCon.prepareStatement(sqlSelectStr);
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, ctx.getContextId());
            stmt.setInt(3, userId);
            stmt.setInt(4, userId);
            stmt.setInt(5, 1);
            if (since != null) {
                stmt.setLong(6, since.getTime());
            }
            rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw e;
        }
        catch (Throwable t) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
        return new FolderObjectIterator(rs, stmt, false, ctx, readCon, true);
    }

    private static SearchIterator getVisiblePublicFolders(int userId, int[] groups, int[] accessibleModules, Context ctx, Timestamp since) throws OXException, SearchIteratorException {
        StringBuilder condBuilder = new StringBuilder("AND (ot.type = ").append(2).append(") AND (ot.parent = ?)").append(since == null ? STR_EMPTY : " AND (changing_date > ?)");
        String sqlSelectStr = OXFolderTools.getSQLUserVisibleFolders(FolderObjectIterator.getFieldsForSQL("ot"), StringCollection.getSqlInString(userId, groups), StringCollection.getSqlInString(accessibleModules), condBuilder.toString(), OXFolderProperties.isEnableDBGrouping() ? "GROUP BY ot.fuid" : null, "ORDER by ot.fuid");
        Connection readCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            readCon = DBPool.pickup(ctx);
            stmt = readCon.prepareStatement(sqlSelectStr);
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, ctx.getContextId());
            stmt.setInt(3, userId);
            stmt.setInt(4, userId);
            stmt.setInt(5, 2);
            if (since != null) {
                stmt.setLong(6, since.getTime());
            }
            rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw e;
        }
        catch (Throwable t) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
        return new FolderObjectIterator(rs, stmt, false, ctx, readCon, true);
    }

    private static SearchIterator getVisibleSharedFolders(int userId, int[] groups, int[] accessibleModules, Context ctx, Timestamp since) throws OXException, SearchIteratorException {
        return OXFolderTools.getVisibleSharedFolders(userId, groups, accessibleModules, -1, ctx, since);
    }

    private static SearchIterator getVisibleSubfoldersIterator(FolderObject parentFolder, int userId, int[] memberInGroups, int[] accessibleModules, Context ctx, Timestamp since) throws OXException, SearchIteratorException {
        boolean shared = parentFolder.isShared(userId);
        StringBuilder condBuilder = new StringBuilder();
        if (shared) {
            condBuilder.append("AND (ot.type = ").append(1).append(" AND ot.created_from != ").append(userId).append(") ");
        }
        condBuilder.append("AND (ot.parent = ?)").append(since == null ? STR_EMPTY : " AND (changing_date > ?)");
        String sqlSelectStr = OXFolderTools.getSQLUserVisibleFolders(FolderObjectIterator.getFieldsForSQL("ot"), StringCollection.getSqlInString(userId, memberInGroups), StringCollection.getSqlInString(accessibleModules), condBuilder.toString(), OXFolderProperties.isEnableDBGrouping() ? "GROUP BY ot.fuid" : null, "ORDER by ot.fuid");
        Connection readCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            readCon = DBPool.pickup(ctx);
            stmt = readCon.prepareStatement(sqlSelectStr);
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, ctx.getContextId());
            stmt.setInt(3, userId);
            stmt.setInt(4, userId);
            stmt.setInt(5, parentFolder.getObjectID());
            if (since != null) {
                stmt.setLong(6, since.getTime());
            }
            rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw e;
        }
        catch (Throwable t) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
        return new FolderObjectIterator(rs, stmt, false, ctx, readCon, true);
    }

    public static SearchIterator getVisibleSharedFolders(int userId, int[] memberInGroups, int[] accessibleModules, int owner, Context ctx, Timestamp since) throws OXException, SearchIteratorException {
        StringBuilder condBuilder = new StringBuilder("AND (ot.type = ").append(1).append(" AND ot.created_from != ").append(userId).append(')');
        if (owner > -1) {
            condBuilder.append(" AND (ot.created_from = ").append(owner).append(')');
        }
        condBuilder.append(since == null ? STR_EMPTY : " AND (changing_date > ?)");
        String sqlSelectStr = OXFolderTools.getSQLUserVisibleFolders(FolderObjectIterator.getFieldsForSQL("ot"), StringCollection.getSqlInString(userId, memberInGroups), StringCollection.getSqlInString(accessibleModules), condBuilder.toString(), OXFolderProperties.isEnableDBGrouping() ? "GROUP BY ot.fuid" : null, "ORDER BY ot.fuid");
        Connection readCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            readCon = DBPool.pickup(ctx);
            stmt = readCon.prepareStatement(sqlSelectStr);
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, ctx.getContextId());
            stmt.setInt(3, userId);
            stmt.setInt(4, userId);
            if (since != null) {
                stmt.setLong(5, since.getTime());
            }
            rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw e;
        }
        catch (Throwable t) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
        return new FolderObjectIterator(rs, stmt, false, ctx, readCon, true);
    }

    public static SearchIterator getAllVisibleFoldersNotSeenInTreeView(int userId, int[] groups, UserConfiguration userConfig, Context ctx) throws OXException, SearchIteratorException {
        Connection readCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            readCon = DBPool.pickup(ctx);
            StringBuilder sql = new StringBuilder(1000);
            sql.append("SELECT ").append(FolderObjectIterator.getFieldsForSQL("ot"));
            sql.append(" FROM oxfolder_tree AS ot JOIN oxfolder_permissions AS op ON ot.fuid = op.fuid AND ot.cid = ? AND op.cid = ?");
            sql.append(" WHERE ((ot.permission_flag = ").append(2);
            sql.append(") OR (ot.permission_flag = ").append(1).append(" AND ot.created_from = ?)");
            sql.append(" OR (op.admin_flag = 1 AND op.permission_id = ?) OR (op.fp > 0 AND op.permission_id IN ");
            sql.append(StringCollection.getSqlInString(userId, groups)).append(")) AND ot.parent IN (");
            sql.append("SELECT res.fuid FROM oxfolder_tree AS res WHERE res.cid = ? AND res.fuid NOT IN (");
            sql.append("SELECT ot2.fuid FROM oxfolder_tree AS ot2 JOIN oxfolder_permissions AS op2 ON ot2.fuid = op2.fuid AND ot2.cid = ? AND op2.cid = ?");
            sql.append(" WHERE (ot2.permission_flag = ").append(2);
            sql.append(") OR (ot2.permission_flag = ").append(1).append(" AND ot2.created_from = ?)");
            sql.append(" OR (op2.admin_flag = 1 AND op2.permission_id = ?) OR (op2.fp > 0 AND op2.permission_id IN ");
            sql.append(StringCollection.getSqlInString(userId, groups)).append("))) AND ot.type = ");
            sql.append(2).append(" AND ot.module IN ");
            sql.append(StringCollection.getSqlInString(userConfig.getAccessibleModules()));
            sql.append(" GROUP BY ot.fuid ORDER BY ot.module, ot.fuid");
            stmt = readCon.prepareStatement(sql.toString());
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, ctx.getContextId());
            stmt.setInt(3, userId);
            stmt.setInt(4, userId);
            stmt.setInt(5, ctx.getContextId());
            stmt.setInt(6, ctx.getContextId());
            stmt.setInt(7, ctx.getContextId());
            stmt.setInt(8, userId);
            stmt.setInt(9, userId);
            rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            DBUtils.closeResources(rs, stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, stmt, readCon, true, ctx);
            throw e;
        }
        catch (Throwable t) {
            DBUtils.closeResources(rs, stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
        return new FolderObjectIterator(rs, stmt, false, ctx, readCon, true);
    }

    public static SearchIterator getVisibleFoldersNotSeenInTreeView(int userId, int[] groups, int module, UserConfiguration userConfig, Context ctx) throws OXException, SearchIteratorException {
        Connection readCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            readCon = DBPool.pickup(ctx);
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT ").append(FolderObjectIterator.getFieldsForSQL("ot")).append(" FROM oxfolder_tree AS ot ").append("LEFT JOIN oxfolder_permissions AS op ON ot.fuid = op.fuid ").append(" AND ot.cid = ? AND op.cid = ? ").append("WHERE ((ot.permission_flag = ").append(2).append(") OR (ot.permission_flag = ").append(1).append(" AND ot.created_from = ?) OR (op.admin_flag = 1 AND op.permission_id = ?) ").append(" OR (op.fp > 0 AND op.permission_id IN ").append(StringCollection.getSqlInString(userId, groups)).append("))").append(" AND ot.parent NOT IN (SELECT ot2.fuid FROM oxfolder_tree AS ot2 LEFT JOIN oxfolder_permissions AS op2 ON ot2.fuid = op2.fuid ").append(" AND ot2.cid = ? AND op2.cid = ? ").append(" WHERE ((ot2.permission_flag = ").append(2).append(") OR (ot2.permission_flag = ").append(1).append(" AND ot2.created_from = ?)").append(" OR (op2.admin_flag = 1 AND op2.permission_id = ?) ").append(" OR (op2.fp > 0 AND op2.permission_id IN ").append(StringCollection.getSqlInString(userId, groups)).append(")) AND ot2.type != ").append(1).append(") AND ot.type != ").append(1).append(" AND ot.module = ").append(module).append(" AND ot.module IN ").append(StringCollection.getSqlInString(userConfig.getAccessibleModules())).append(OXFolderProperties.isEnableDBGrouping() ? " GROUP BY ot.fuid" : STR_EMPTY);
            stmt = readCon.prepareStatement(sb.toString());
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, ctx.getContextId());
            stmt.setInt(3, userId);
            stmt.setInt(4, userId);
            stmt.setInt(5, ctx.getContextId());
            stmt.setInt(6, ctx.getContextId());
            stmt.setInt(7, userId);
            stmt.setInt(8, userId);
            rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            DBUtils.closeResources(rs, stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, stmt, readCon, true, ctx);
            throw e;
        }
        catch (Throwable t) {
            DBUtils.closeResources(rs, stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
        return new FolderObjectIterator(rs, stmt, false, ctx, readCon, true);
    }

    public static SearchIterator getFoldersOnPathToRoot(int folderId, int userId, UserConfiguration userConfig, Locale locale, Context ctx) throws OXException, SearchIteratorException {
        ArrayList<FolderObject> folderList = new ArrayList<FolderObject>();
        OXFolderTools.fillAncestor(folderList, folderId, userId, userConfig, locale, null, ctx);
        return new FolderObjectIterator(folderList, false);
    }

    private static void fillAncestor(List<FolderObject> folderList, int folderId, int userId, UserConfiguration userConfig, Locale locale, UserStorage userStoreArg, Context ctx) throws OXException {
        if (OXFolderTools.checkForSpecialFolder(folderList, folderId, locale, ctx)) {
            return;
        }
        UserStorage userStore = userStoreArg;
        FolderObject fo = new OXFolderAccess(ctx).getFolderObject(folderId);
        try {
            if (!fo.getEffectiveUserPermission(userId, userConfig).isFolderVisible()) {
                if (folderList.isEmpty()) {
                    throw OXFolderExceptionCode.NOT_VISIBLE.create(folderId, OXFolderUtility.getUserName(userId, ctx), ctx.getContextId());
                }
                return;
            }
            if (fo.isShared(userId)) {
                String creatorDisplayName;
                folderList.add(fo);
                if (userStore == null) {
                    userStore = UserStorage.getInstance();
                }
                try {
                    creatorDisplayName = userStore.getUser(fo.getCreatedBy(), ctx).getDisplayName();
                }
                catch (OXException e) {
                    if (fo.getCreatedBy() != 0) {
                        throw e;
                    }
                    StringHelper strHelper = StringHelper.valueOf(locale);
                    creatorDisplayName = strHelper.getString("All users");
                }
                FolderObject virtualOwnerFolder = FolderObject.createVirtualFolderObject("u:" + fo.getCreatedBy(), creatorDisplayName, 5, true, 5);
                folderList.add(virtualOwnerFolder);
                fo = new OXFolderAccess(ctx).getFolderObject(3);
                fo.setFolderName(FolderObject.getFolderString(3, locale));
                folderList.add(fo);
                return;
            }
            if (fo.getType() == 2 && OXFolderTools.hasNonVisibleParent(fo, userId, userConfig, ctx)) {
                int virtualParent;
                folderList.add(fo);
                switch (fo.getModule()) {
                    case 1: {
                        virtualParent = 11;
                        break;
                    }
                    case 2: {
                        virtualParent = 12;
                        break;
                    }
                    case 3: {
                        virtualParent = 13;
                        break;
                    }
                    case 8: {
                        virtualParent = 14;
                        break;
                    }
                    default: {
                        throw OXFolderExceptionCode.UNKNOWN_MODULE.create(OXFolderUtility.folderModule2String(fo.getModule()), ctx.getContextId());
                    }
                }
                OXFolderTools.checkForSpecialFolder(folderList, virtualParent, locale, ctx);
                return;
            }
            folderList.add(fo);
            if (fo.getParentFolderID() != 0) {
                OXFolderTools.fillAncestor(folderList, fo.getParentFolderID(), userId, userConfig, locale, userStore, ctx);
            }
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            throw e;
        }
        catch (Throwable t) {
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
    }

    private static final boolean checkForSpecialFolder(List<FolderObject> folderList, int folderId, Locale locale, Context ctx) throws OXException {
        boolean publicParent;
        FolderObject specialFolder;
        switch (folderId) {
            case 6: {
                specialFolder = new OXFolderAccess(ctx).getFolderObject(folderId);
                specialFolder.setFolderName(FolderObject.getFolderString(6, locale));
                publicParent = true;
                break;
            }
            case 11: {
                specialFolder = FolderObject.createVirtualFolderObject(11, FolderObject.getFolderString(11, locale), 5, true, 5);
                publicParent = true;
                break;
            }
            case 12: {
                specialFolder = FolderObject.createVirtualFolderObject(12, FolderObject.getFolderString(12, locale), 5, true, 5);
                publicParent = true;
                break;
            }
            case 13: {
                specialFolder = FolderObject.createVirtualFolderObject(13, FolderObject.getFolderString(13, locale), 5, true, 5);
                publicParent = true;
                break;
            }
            case 14: {
                specialFolder = FolderObject.createVirtualFolderObject(14, FolderObject.getFolderString(14, locale), 5, true, 5);
                publicParent = false;
                break;
            }
            default: {
                return false;
            }
        }
        folderList.add(specialFolder);
        int parentId = publicParent ? 2 : 9;
        FolderObject parent = new OXFolderAccess(ctx).getFolderObject(parentId);
        parent.setFolderName(FolderObject.getFolderString(parentId, locale));
        folderList.add(parent);
        return true;
    }

    private static final boolean hasNonVisibleParent(FolderObject fo, int userId, UserConfiguration userConf, Context ctx) throws OXException, OXException, SQLException {
        if (fo.getParentFolderID() == 0) {
            return false;
        }
        FolderObject parent = new OXFolderAccess(ctx).getFolderObject(fo.getParentFolderID());
        return !parent.getEffectiveUserPermission(userId, userConf).isFolderVisible();
    }

    public static SearchIterator getAllVisibleFoldersIteratorOfType(int userId, int[] memberInGroups, int[] accessibleModules, int type, int[] modules, Context ctx) throws OXException, SearchIteratorException {
        return OXFolderTools.getAllVisibleFoldersIteratorOfType(userId, memberInGroups, accessibleModules, type, modules, null, ctx);
    }

    public static SearchIterator getAllVisibleFoldersIteratorOfType(int userId, int[] memberInGroups, int[] accessibleModules, int type, int[] modules, int parent, Context ctx) throws OXException, SearchIteratorException {
        return OXFolderTools.getAllVisibleFoldersIteratorOfType(userId, memberInGroups, accessibleModules, type, modules, (Integer)parent, ctx);
    }

    private static SearchIterator getAllVisibleFoldersIteratorOfType(int userId, int[] memberInGroups, int[] accessibleModules, int type, int[] modules, Integer parent, Context ctx) throws OXException, SearchIteratorException {
        StringBuilder condBuilder = new StringBuilder("AND (ot.module IN (");
        condBuilder.append(modules[0]);
        for (int i = 1; i < modules.length; ++i) {
            condBuilder.append(", ").append(modules[i]);
        }
        condBuilder.append(")) AND (ot.type = ?");
        if (type == 3) {
            condBuilder.append(" AND ot.created_from != ").append(userId);
        }
        condBuilder.append(')');
        if (parent != null) {
            condBuilder.append(" AND (ot.parent = ").append(parent).append(')');
        }
        Connection readCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            readCon = DBPool.pickup(ctx);
            stmt = readCon.prepareStatement(OXFolderTools.getSQLUserVisibleFolders(FolderObjectIterator.getFieldsForSQL("ot"), StringCollection.getSqlInString(userId, memberInGroups), StringCollection.getSqlInString(accessibleModules), condBuilder.toString(), OXFolderProperties.isEnableDBGrouping() ? "GROUP BY ot.fuid" : null, "ORDER BY ot.fuid"));
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, ctx.getContextId());
            stmt.setInt(3, userId);
            stmt.setInt(4, userId);
            stmt.setInt(5, type == 3 ? 1 : type);
            rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            DBUtils.closeResources(rs, stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, stmt, readCon, true, ctx);
            throw e;
        }
        catch (Throwable t) {
            DBUtils.closeResources(rs, stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
        return new FolderObjectIterator(rs, stmt, false, ctx, readCon, true);
    }

    public static SearchIterator getAllVisibleFoldersIteratorOfModule(int userId, int[] memberInGroups, int[] accessibleModules, int module, Context ctx) throws OXException, SearchIteratorException {
        return OXFolderTools.getAllVisibleFoldersIteratorOfModule(userId, memberInGroups, accessibleModules, module, null, ctx);
    }

    public static SearchIterator getAllVisibleFoldersIteratorOfModule(int userId, int[] memberInGroups, int[] accessibleModules, int module, Connection readConArg, Context ctx) throws OXException, SearchIteratorException {
        String sqlSelectStr = OXFolderTools.getSQLUserVisibleFolders(FolderObjectIterator.getFieldsForSQL("ot"), StringCollection.getSqlInString(userId, memberInGroups), StringCollection.getSqlInString(accessibleModules), "AND (ot.module = ?)", OXFolderProperties.isEnableDBGrouping() ? "GROUP BY ot.fuid" : null, "ORDER BY ot.fuid");
        boolean closeReadCon = readConArg == null;
        Connection readCon = closeReadCon ? DBPool.pickup(ctx) : readConArg;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = readCon.prepareStatement(sqlSelectStr);
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, ctx.getContextId());
            stmt.setInt(3, userId);
            stmt.setInt(4, userId);
            stmt.setInt(5, module);
            rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (Throwable t) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
        return new FolderObjectIterator(rs, stmt, false, ctx, readCon, closeReadCon);
    }

    public static SearchIterator getDeletedFoldersSince(Date since, int userId, int[] memberInGroups, int[] accessibleModules, Context ctx) throws OXException, SearchIteratorException {
        String fields = FolderObjectIterator.getFieldsForSQL("ot");
        StringBuilder sqlBuilder = new StringBuilder("SELECT ").append(fields).append(" FROM del_oxfolder_tree AS ot JOIN del_oxfolder_permissions AS op ON ot.fuid = op.fuid AND ot.cid = ? AND op.cid = ? ").append("WHERE ((ot.permission_flag = ").append(2).append(" OR (ot.permission_flag = ").append(1).append(" AND ot.created_from = ?)) OR ").append("((op.admin_flag = 1 AND op.permission_id = ?) OR (op.fp > ? AND op.permission_id IN ").append(StringCollection.getSqlInString(userId, memberInGroups)).append("))) AND (changing_date > ?)").append(" AND (ot.module IN ").append(StringCollection.getSqlInString(accessibleModules)).append(')').append(OXFolderProperties.isEnableDBGrouping() ? " GROUP BY ot.fuid" : STR_EMPTY).append(" ORDER by ot.fuid");
        Connection readCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            readCon = DBPool.pickup(ctx);
            stmt = readCon.prepareStatement(sqlBuilder.toString());
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, ctx.getContextId());
            stmt.setInt(3, userId);
            stmt.setInt(4, userId);
            stmt.setInt(5, 0);
            stmt.setLong(6, since.getTime());
            rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw e;
        }
        catch (Throwable t) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
        return new FolderObjectIterator(rs, stmt, false, ctx, readCon, true);
    }

    public static SearchIterator getModifiedFoldersSince(Date since, int userId, int[] memberInGroups, int[] accessibleModules, boolean userFoldersOnly, Context ctx) throws OXException, SearchIteratorException {
        StringBuilder condBuilder = new StringBuilder("AND (changing_date > ?) AND (module IN ").append(FolderObject.SQL_IN_STR_STANDARD_MODULES).append(')');
        if (userFoldersOnly) {
            condBuilder.append(" AND (ot.created_from = ").append(userId).append(") ");
        }
        String sqlSelectStr = OXFolderTools.getSQLUserVisibleFolders(FolderObjectIterator.getFieldsForSQL("ot"), StringCollection.getSqlInString(userId, memberInGroups), StringCollection.getSqlInString(accessibleModules), condBuilder.toString(), OXFolderProperties.isEnableDBGrouping() ? "GROUP BY ot.fuid" : null, "ORDER by ot.fuid");
        Connection readCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            readCon = DBPool.pickup(ctx);
            stmt = readCon.prepareStatement(sqlSelectStr);
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, ctx.getContextId());
            stmt.setInt(3, userId);
            stmt.setInt(4, userId);
            stmt.setLong(5, since.getTime());
            rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw e;
        }
        catch (Throwable t) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
        return new FolderObjectIterator(rs, stmt, false, ctx, readCon, true);
    }

    public static SearchIterator getAllModifiedFoldersSince(Date since, Context ctx) throws OXException, SearchIteratorException {
        String sqlSelectStr = new StringBuilder(300).append(SQL_SELECT_FOLDERS_START).append("AND (changing_date > ?) AND (module IN ").append(FolderObject.SQL_IN_STR_STANDARD_MODULES).append(") ").append(OXFolderProperties.isEnableDBGrouping() ? "GROUP BY ot.fuid" : null).append(" ORDER by ot.fuid").toString();
        Connection readCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            readCon = DBPool.pickup(ctx);
            stmt = readCon.prepareStatement(sqlSelectStr);
            stmt.setInt(1, ctx.getContextId());
            stmt.setLong(2, since.getTime());
            rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw e;
        }
        catch (Throwable t) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
        return new FolderObjectIterator(rs, stmt, false, ctx, readCon, true);
    }

    public static FolderObject getUsersInfostoreFolder(int userId, Context ctx) throws OXException {
        return OXFolderTools.getUsersInfostoreFolder(userId, ctx, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FolderObject getUsersInfostoreFolder(int userId, Context ctx, Connection readConArg) throws OXException {
        Connection readCon = readConArg;
        boolean createCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            block7: {
                FolderObject folderObject;
                try {
                    if (readCon == null) {
                        readCon = DBPool.pickup(ctx);
                        createCon = true;
                    }
                    stmt = readCon.prepareStatement("SELECT fuid FROM oxfolder_tree WHERE cid = ? AND created_from = ? AND module = ? AND default_flag = ?");
                    stmt.setInt(1, ctx.getContextId());
                    stmt.setInt(2, userId);
                    stmt.setInt(3, 8);
                    stmt.setInt(4, 1);
                    rs = stmt.executeQuery();
                    if (!rs.next()) break block7;
                    FolderObject fo = FolderCacheManager.isEnabled() ? FolderCacheManager.getInstance().getFolderObject(rs.getInt(1), true, ctx, readCon) : FolderObject.loadFolderObjectFromDB(rs.getInt(1), ctx, readCon);
                    folderObject = fo;
                    DBUtils.closeResources(rs, (Statement)stmt, createCon ? readCon : null, true, ctx);
                }
                catch (Throwable throwable) {
                    DBUtils.closeResources(rs, (Statement)stmt, createCon ? readCon : null, true, ctx);
                    throw throwable;
                }
                return folderObject;
            }
            throw OXFolderExceptionCode.NO_DEFAULT_FOLDER_FOUND.create(OXFolderUtility.folderModule2String(8), OXFolderUtility.getUserName(userId, ctx), ctx.getContextId());
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (Throwable t) {
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFolderParentIdFromDB(int folderId, Context ctx, Connection readConArg) throws OXException {
        int n;
        Connection readCon = readConArg;
        boolean closeCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            if (readCon == null) {
                readCon = DBPool.pickup(ctx);
                closeCon = true;
            }
            stmt = readCon.prepareStatement("SELECT parent FROM oxfolder_tree WHERE cid = ? AND fuid = ?");
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, folderId);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw OXFolderExceptionCode.NOT_EXISTS.create(folderId, ctx.getContextId());
            }
            int retval = rs.getInt(1);
            n = retval;
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
        }
        catch (Throwable throwable) {
            try {
                DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
                throw throwable;
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable t) {
                throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFolderNameFromDB(int folderId, Context ctx, Connection readConArg) throws OXException {
        String string;
        Connection readCon = readConArg;
        boolean closeCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            if (readCon == null) {
                readCon = DBPool.pickup(ctx);
                closeCon = true;
            }
            stmt = readCon.prepareStatement("SELECT fname FROM oxfolder_tree WHERE cid = ? AND fuid = ?");
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, folderId);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw OXFolderExceptionCode.NOT_EXISTS.create(folderId, ctx.getContextId());
            }
            String retval = rs.getString(1);
            string = retval;
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
        }
        catch (Throwable throwable) {
            try {
                DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
                throw throwable;
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable t) {
                throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
            }
        }
        return string;
    }

    public static Date getFolderLastModifed(int folderId, Context ctx) throws OXException {
        if (FolderCacheManager.isEnabled()) {
            return FolderCacheManager.getInstance().getFolderObject(folderId, true, ctx, null).getLastModified();
        }
        return OXFolderTools.getFolderLastModifedFromDB(folderId, ctx);
    }

    public static Date getFolderLastModifedFromDB(int folderId, Context ctx) throws OXException {
        return OXFolderTools.getFolderLastModifedFromDB(folderId, ctx, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getFolderLastModifedFromDB(int folderId, Context ctx, Connection readConArg) throws OXException {
        Date date;
        Connection readCon = readConArg;
        boolean closeCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            if (readCon == null) {
                readCon = DBPool.pickup(ctx);
                closeCon = true;
            }
            stmt = readCon.prepareStatement("SELECT changing_date FROM oxfolder_tree WHERE cid = ? AND fuid = ?");
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, folderId);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw OXFolderExceptionCode.NOT_EXISTS.create(folderId, ctx.getContextId());
            }
            Date retval = new Date(rs.getLong(1));
            date = retval;
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
        }
        catch (Throwable throwable) {
            try {
                DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
                throw throwable;
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable t) {
                throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
            }
        }
        return date;
    }

    public static boolean canDeleteAllObjectsInFolder(FolderObject fo, Session session, Connection readCon) throws OXException {
        int userId = session.getUserId();
        Context ctx = ContextStorage.getStorageContext(session);
        UserPermissionBits permissionBits = UserPermissionBitsStorage.getInstance().getUserPermissionBits(session.getUserId(), ctx);
        try {
            EffectivePermission oclPerm = fo.getEffectiveUserPermission(userId, permissionBits, readCon);
            if (!((OCLPermission)oclPerm).isFolderVisible()) {
                return false;
            }
            if (((OCLPermission)oclPerm).canDeleteAllObjects()) {
                return true;
            }
            if (((OCLPermission)oclPerm).canDeleteOwnObjects()) {
                switch (fo.getModule()) {
                    case 1: {
                        Tasks tasks2 = Tasks.getInstance();
                        return !tasks2.containsNotSelfCreatedTasks(session, fo.getObjectID());
                    }
                    case 2: {
                        AppointmentSQLInterface calSql = ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class).createAppointmentSql(session);
                        return !calSql.checkIfFolderContainsForeignObjects(userId, fo.getObjectID());
                    }
                    case 3: {
                        ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class, true);
                        return false == contactService.containsForeignObjectInFolder(session, String.valueOf(fo.getObjectID()));
                    }
                    case 8: {
                        InfostoreFacadeImpl db = new InfostoreFacadeImpl(new DBPoolProvider());
                        return !db.hasFolderForeignObjects(fo.getObjectID(), ServerSessionAdapter.valueOf(session, ctx));
                    }
                }
                throw OXFolderExceptionCode.UNKNOWN_MODULE.create(OXFolderUtility.folderModule2String(fo.getModule()), ctx.getContextId());
            }
            switch (fo.getModule()) {
                case 1: {
                    Tasks tasks3 = Tasks.getInstance();
                    return tasks3.isFolderEmpty(ctx, fo.getObjectID());
                }
                case 2: {
                    AppointmentSQLInterface calSql = ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class).createAppointmentSql(session);
                    return calSql.isFolderEmpty(userId, fo.getObjectID());
                }
                case 3: {
                    ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class, true);
                    return contactService.isFolderEmpty(session, String.valueOf(fo.getObjectID()));
                }
                case 8: {
                    InfostoreFacadeImpl db = new InfostoreFacadeImpl(new DBPoolProvider());
                    return db.isFolderEmpty(fo.getObjectID(), ctx);
                }
            }
            throw OXFolderExceptionCode.UNKNOWN_MODULE.create(OXFolderUtility.folderModule2String(fo.getModule()), ctx.getContextId());
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (Throwable t) {
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
    }
}

