/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.images.transformations;

import com.openexchange.tools.images.impl.ImageInformation;
import com.openexchange.tools.images.transformations.ImageTransformation;
import com.openexchange.tools.images.transformations.TransformationContext;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RotateTransformation
implements ImageTransformation {
    private static Logger LOG = LoggerFactory.getLogger(RotateTransformation.class);

    @Override
    public BufferedImage perform(BufferedImage sourceImage, TransformationContext transformationContext, ImageInformation imageInformation) throws IOException {
        int newHeight;
        int newWidth;
        if (null == imageInformation) {
            LOG.debug("No image information available, unable to rotate image");
            return sourceImage;
        }
        AffineTransform exifTransformation = this.getExifTransformation(imageInformation);
        if (null == exifTransformation) {
            LOG.debug("No EXIF transformation available, unable to rotate image");
            return sourceImage;
        }
        if (imageInformation.orientation <= 4) {
            newWidth = sourceImage.getWidth();
            newHeight = sourceImage.getHeight();
        } else {
            newWidth = sourceImage.getHeight();
            newHeight = sourceImage.getWidth();
        }
        BufferedImage destinationImage = new BufferedImage(newWidth, newHeight, sourceImage.getType());
        Graphics2D g = destinationImage.createGraphics();
        g.setBackground(Color.WHITE);
        g.clearRect(0, 0, destinationImage.getWidth(), destinationImage.getHeight());
        g.drawImage(sourceImage, exifTransformation, null);
        transformationContext.addExpense(1);
        return destinationImage;
    }

    private AffineTransform getExifTransformation(ImageInformation info) {
        AffineTransform t = new AffineTransform();
        switch (info.orientation) {
            default: {
                return null;
            }
            case 2: {
                t.scale(-1.0, 1.0);
                t.translate(-info.width, 0.0);
                break;
            }
            case 3: {
                t.translate(info.width, info.height);
                t.rotate(Math.PI);
                break;
            }
            case 4: {
                t.scale(1.0, -1.0);
                t.translate(0.0, -info.height);
                break;
            }
            case 5: {
                t.rotate(-1.5707963267948966);
                t.scale(-1.0, 1.0);
                break;
            }
            case 6: {
                t.translate(info.height, 0.0);
                t.rotate(1.5707963267948966);
                break;
            }
            case 7: {
                t.scale(-1.0, 1.0);
                t.translate(-info.height, 0.0);
                t.translate(0.0, info.width);
                t.rotate(4.71238898038469);
                break;
            }
            case 8: {
                t.translate(0.0, info.width);
                t.rotate(4.71238898038469);
            }
        }
        return t;
    }

    @Override
    public boolean needsImageInformation() {
        return true;
    }

    @Override
    public boolean supports(String formatName) {
        return null != formatName && "jpeg".equalsIgnoreCase(formatName) || "jpg".equalsIgnoreCase(formatName) || "tiff".equalsIgnoreCase(formatName) || "psd".equalsIgnoreCase(formatName);
    }
}

