/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.caching;

import com.openexchange.caching.Cache;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.internal.SchemaStoreImpl;
import com.openexchange.tools.caching.StorageLoader;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializedCachingLoader {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaStoreImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Serializable> T fetch(Cache cache, String regionName, String groupName, Lock lock, StorageLoader<T> loader) throws OXException {
        if (null == cache) {
            return (T)((Serializable)loader.load());
        }
        Serializable retval = null;
        try {
            if (!lock.tryLock(500L, TimeUnit.MILLISECONDS)) {
                return (T)((Serializable)loader.load());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("", (Throwable)e);
            return (T)((Serializable)loader.load());
        }
        Serializable key = loader.getKey();
        Condition cond = null;
        try {
            Object tmp = SerializedCachingLoader.get(cache, groupName, key);
            if (null == tmp) {
                cond = lock.newCondition();
                SerializedCachingLoader.putSafe(cache, groupName, key, (Serializable)((Object)cond), false);
            } else if (tmp instanceof Condition) {
                cond = (Condition)tmp;
                if (cond.await(1L, TimeUnit.SECONDS)) {
                    Object tmp2 = SerializedCachingLoader.get(cache, groupName, key);
                    if (null != tmp2 && !(tmp2 instanceof Condition)) {
                        retval = (Serializable)tmp2;
                        cond = null;
                    }
                } else {
                    LOG.warn("Found 2 threads loading object \"" + String.valueOf(key) + "\" after 1 second into Cache \"" + regionName + "\"");
                }
            } else {
                retval = (Serializable)tmp;
            }
        }
        catch (InterruptedException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        finally {
            lock.unlock();
        }
        if (null != cond) {
            try {
                retval = (Serializable)loader.load();
            }
            catch (OXException e) {
                SerializedCachingLoader.remove(cache, groupName, key);
                throw e;
            }
            lock.lock();
            try {
                SerializedCachingLoader.put(cache, groupName, key, retval, false);
                cond.signalAll();
            }
            finally {
                lock.unlock();
            }
        }
        return (T)retval;
    }

    private static Object get(Cache cache, String groupName, Serializable key) {
        Object retval = null == groupName ? cache.get(key) : cache.getFromGroup(key, groupName);
        return retval;
    }

    private static void put(Cache cache, String groupName, Serializable key, Serializable value, boolean invalidate) throws OXException {
        if (null == groupName) {
            cache.put(key, value, invalidate);
        } else {
            cache.putInGroup(key, groupName, value, invalidate);
        }
    }

    private static void putSafe(Cache cache, String groupName, Serializable key, Serializable value, boolean invalidate) throws OXException {
        if (null == groupName) {
            cache.putSafe(key, value);
        } else {
            cache.putInGroup(key, groupName, value, invalidate);
        }
    }

    private static void remove(Cache cache, String groupName, Serializable key) throws OXException {
        if (null == groupName) {
            cache.remove(key);
        } else {
            cache.removeFromGroup(key, groupName);
        }
    }
}

