/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server.osgi;

import com.openexchange.passwordchange.PasswordChangeService;
import com.openexchange.passwordchange.service.PasswordChange;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PasswordChangeCustomizer
implements ServiceTrackerCustomizer<PasswordChangeService, PasswordChangeService> {
    private static final Logger LOG = LoggerFactory.getLogger(PasswordChangeCustomizer.class);
    private final BundleContext context;

    public PasswordChangeCustomizer(BundleContext context) {
        this.context = context;
    }

    public PasswordChangeService addingService(ServiceReference<PasswordChangeService> reference) {
        PasswordChangeService addedService = (PasswordChangeService)this.context.getService(reference);
        if (null == addedService) {
            LOG.warn("Added service is null!", new Throwable());
        }
        if (PasswordChange.getService() == null) {
            PasswordChange.setService(addedService);
        } else {
            LOG.error("Several password change services found. Remove all except one!", new Throwable());
        }
        return addedService;
    }

    public void modifiedService(ServiceReference<PasswordChangeService> reference, PasswordChangeService service) {
        LOG.trace("UserPasswordChangeCustomizer.modifiedService()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<PasswordChangeService> reference, PasswordChangeService service) {
        try {
            if (PasswordChange.getService() == service) {
                PasswordChange.setService(null);
            }
        }
        finally {
            this.context.ungetService(reference);
        }
    }
}

